/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;

public class MaskatNamespacePrefixMapper extends NamespacePrefixMapper {
	private HashMap prefixesByUri = new HashMap();
	
	public String getPrefix(String namespaceUri) {
		return super.getPrefix(namespaceUri);
	}

	public void setPrefix(String namespaceUri, String prefix) {
        prefixesByUri.put(namespaceUri, prefix);
		super.setPrefix(namespaceUri, prefix);
	}
	
	public Map getPrefixes() {
		return prefixesByUri;
	}
}
