/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.action;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.command.DeleteOneTreeNodeCommand;
import org.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class DeleteOneNodeAction extends AbstractAction {

	private ITreeNode nodeToBeDeleted;
	
	public DeleteOneNodeAction(TreeViewer treeViewer, ITreeNode nodeToBeDeleted) {
		super(treeViewer);
		this.nodeToBeDeleted = nodeToBeDeleted;
	}
	
	public String getText() {
		return Messages.getString("deleteOneNodeAction.deleteLabel"); //$NON-NLS-1$
	}
	
	public ImageDescriptor getImageDescriptor() {
		return null;
	}
	
	public void run() {
		ITreeNode parent = nodeToBeDeleted.getParent(); 
		EventPropertiesMasterDetailsBlock.executeCommand(new DeleteOneTreeNodeCommand(treeViewer, parent, nodeToBeDeleted));
//		parent.removeChild(nodeToBeDeleted);
//		treeViewer.refresh(parent);
//		treeViewer.setSelection(new StructuredSelection(parent));
	}
}
