/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

import org.maskat.core.layout.Button;
import org.maskat.core.layout.Checkbox;
import org.maskat.core.layout.CodeLib;
import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.core.layout.DivHtml;
import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Frame;
import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridCell;
import org.maskat.core.layout.GridCellCombo;
import org.maskat.core.layout.GridHeader;
import org.maskat.core.layout.GridLine;
import org.maskat.core.layout.Image;
import org.maskat.core.layout.Label;
import org.maskat.core.layout.Layout;
import org.maskat.core.layout.Popup;
import org.maskat.core.layout.Radio;
import org.maskat.core.layout.Splitter;
import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.TabItem;
import org.maskat.core.layout.Text;
import org.maskat.core.layout.TreeNode;
import org.maskat.core.layout.TreeView;
import org.maskat.core.layout.Window;
import org.maskat.ui.editors.layout.models.SplitModel;
import org.maskat.ui.editors.layout.models.TabDef;

public class MaskatEditPartFactory implements EditPartFactory {

	private static Map factoryClasses;
	
	static {
		factoryClasses = new HashMap();
		factoryClasses.put(Combo.class, ComboEditPart.class);
		factoryClasses.put(TreeView.class, TreeViewEditPart.class);
		factoryClasses.put(TreeNode.class, TreeNodeEditPart.class);
		factoryClasses.put(Text.class, TextEditPart.class);
		factoryClasses.put(Button.class, ButtonEditPart.class);
		factoryClasses.put(Label.class, LabelEditPart.class);
		factoryClasses.put(Checkbox.class, CheckBoxEditPart.class);
		factoryClasses.put(Radio.class, RadioEditPart.class);
		factoryClasses.put(CodeLib.class, CodeLibEditPart.class);
		factoryClasses.put(DivHtml.class, DivHtmlEditPart.class);
		factoryClasses.put(Frame.class, FrameEditPart.class);
		factoryClasses.put(Layout.class, LayoutEditPart.class);
		factoryClasses.put(Grid.class, GridEditPart.class);
		factoryClasses.put(Image.class, ImageEditPart.class);
		factoryClasses.put(ComboItem.class, ComboItemEditPart.class);
		factoryClasses.put(GridHeader.class, GridHeaderEditPart.class);
		factoryClasses.put(TabFolder.class, TabFolderEditPart.class);
		factoryClasses.put(TabItem.class, TabItemEditPart.class);
		factoryClasses.put(TabDef.class, TabEditPart.class);
		factoryClasses.put(Splitter.class, SplitterEditPart.class);
		factoryClasses.put(DivSplit.class, DivSplitEditPart.class);
		factoryClasses.put(SplitModel.class, SplitEditPart.class);
		factoryClasses.put(Popup.class, PopupEditPart.class);
		factoryClasses.put(GridLine.class, GridLineEditPart.class);
		factoryClasses.put(GridCell.class, GridCellEditPart.class);
		factoryClasses.put(GridCellCombo.class, GridCellComboEditPart.class);
		factoryClasses.put(Window.class, WindowEditPart.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart editPart = null;
		Class modelClass = model.getClass();
		if (factoryClasses.containsKey(modelClass)) {
			try {
				Class editPartClass = (Class) factoryClasses.get(modelClass);
				editPart = (EditPart) editPartClass.newInstance();
				// モデルをEditPartに設定する
				editPart.setModel(model); 

			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return editPart;
	}
}
