/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;


import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.Component;
import org.maskat.core.layout.DivHtml;
import org.maskat.ui.editors.layout.figures.DivHtmlFigure;

public class DivHtmlEditPart extends ComponentEditPart
	implements LabelDirectEditable, HorizontalResizable, VerticalResizable {
	
	protected IFigure createFigure() {
		return new DivHtmlFigure(((DivHtml) getModel()).getHtml());
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		int width = comp.getWidth() > 0 ? comp.getWidth() : 80;
		int height = comp.getHeight() > 0 ? comp.getHeight() : 80;
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), width,
				height);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("html".equals(evt.getPropertyName())) {
			((DivHtmlFigure) getFigure()).setText((String) evt.getNewValue());
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}
	
	public String getLabel() {
		return ((DivHtml) getModel()).getHtml();
	}

	public void setLabel(String text) {
		((DivHtml) getModel()).setHtml(text);
	}
}
