/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.Iterator;

public class TreeNode extends AbstractComponent implements ComponentPart {
	
//	public static final String POSITION_DEFAULT = "absolute";
	
	public static final String STEXT_DEFAULT = "";
	
//	public static final String TYPE_INFO_DEFAULT = "node";
	
//	public static final String URL_DEFAULT = "";
	
	public static final boolean OPEN_DEFAULT = true;

//	public static final boolean RELOAD_DEFAULT = false;

	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final String SICON_DEFAULT = "images/imTreeview/pict_synthetik_off.gif";
	
	public static final String SICON2_DEFAULT = "images/imTreeview/pict_synthetik_off.gif";
	
	private String sText = STEXT_DEFAULT;

	private String sIcon = SICON_DEFAULT;

	private String sIcon2 = SICON2_DEFAULT;

	private boolean open = OPEN_DEFAULT;

//	private boolean reload = RELOAD_DEFAULT;

//	private String url = URL_DEFAULT;

//	private String typeInfo = TYPE_INFO_DEFAULT;

	private String onclick;

	private int layer;
	
	private boolean draggable = DRAGGABLE_DEFAULT;
	
//	private String position = POSITION_DEFAULT;

	/** ツリーの左優先遍歴インデックス */
	private int leftIterationIndex;

	public int getLayer() {
		return layer;
	}

	public void setLayer(int layer) {
		this.layer = layer;
	}

	public int getLeftIterationIndex() {
		return leftIterationIndex;
	}

	public void setLeftIterationIndex(int leftIterationIndex) {
		this.leftIterationIndex = leftIterationIndex;
	}

	public String getSIcon() {
		return sIcon;
	}

	public void setSIcon(String icon) {
		this.sIcon = icon;
	}

	public String getSIcon2() {
		return sIcon2;
	}

	public void setSIcon2(String icon2) {
		this.sIcon2 = icon2;
	}

	public String getOnclick() {
		return onclick;
	}

	public void setOnclick(String onclick) {
		this.onclick = onclick;
	}

	public boolean isOpen() {
		return open;
	}

	public void setOpen(boolean open) {
		this.open = open;
	}

//	public boolean isReload() {
//		return reload;
//	}
//
//	public void setReload(boolean reload) {
//		this.reload = reload;
//	}

	public String getSText() {
		return sText;
	}

	public void setSText(String sText) {
		String oldStext = this.sText;
		this.sText = sText;		
		firePropertyChange("sText", oldStext, sText);
	}

//	public String getTypeInfo() {
//		return typeInfo;
//	}
//
//	public void setTypeInfo(String typeInfo) {
//		this.typeInfo = typeInfo;
//	}
//
//	public String getUrl() {
//		return url;
//	}
//
//	public void setUrl(String url) {
//		this.url = url;
//	}

	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

//	public String getPosition() {
//		return position;
//	}
//
//	public void setPosition(String position) {
//		this.position = position;
//	}

	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	public void addChild(Object obj) {
		super.addChild(obj);
		firePropertyChange("addChild", "", null);
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
		firePropertyChange("addChild", "", null);
	}

	/**
	 * 
	 * @param nextIndex
	 * @return nextIndex
	 */
	public int travel(int nextIndex) {
		this.leftIterationIndex = nextIndex++;
		for (Iterator it = this.getTypedChildren(TreeNode.class); 
				it != null && it.hasNext();) {
			TreeNode def = (TreeNode) it.next();
			def.setLayer(layer + 1);
			nextIndex = def.travel(nextIndex);
		}
		return nextIndex;
	}
}
