/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Radio extends AbstractComponent {
	
	public static final boolean CHECKED_DEFAULT = false;
	
	public static final boolean ENABLE_DEFAULT = true; 
	
	public static final String CLASS_NAME_DEFAULT = "libNormal";
	
	public static final int TABINDEX_DEFAULT = -1;
	
	private String text;

	private String className = CLASS_NAME_DEFAULT;

	private String group;

	private boolean checked = CHECKED_DEFAULT;

	private boolean enable = ENABLE_DEFAULT;

	public Radio() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public boolean isChecked() {
		return checked;
	}

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		String oldText = this.text;
		this.text = text;
		firePropertyChange("text", oldText, text);
	}

	public void setTabIndex(int tabIndex) {
		// set the tabIndex of the corresponding group
		if (group != null) {
			RadioGroup rgd = getLayout().findRadioGroupDef(group);
			if (rgd == null) {
				rgd = getLayout().createRadioGroupDef(group);
			}

			rgd.setTabIndex(tabIndex);
		}
	}

	public int getTabIndex() {
		if (group == null) {
//			return null;
			return -1;
		}
		// get the tabIndex value from radioGroup
		RadioGroup rgd = getLayout().findRadioGroupDef(group);
		if (rgd == null) {
			rgd = getLayout().createRadioGroupDef(group);
		}
		return rgd.getTabIndex();
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public String[] getEventTypes() {
		return new String[] {EventTypeConstants.ON_CLICK};
	}
}
