/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Popup extends AbstractContainer {
	
	public static final String TITLE_DEFAULT = "Window";
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final String SUFFFOND_DEFAULT = "transparent";
	
	public static final String CONTENT_DEFAULT = null;
	
	public static final boolean DRAGGABLE_DEFAULT = false;
	
//	public static final boolean ENABLE_DEFAULT = true;
	
	public static final boolean VISIBLE_DEFAULT = false;
	
	public static final boolean WITH_CLOSE_BUTTON_DEFAULT = true;
	
	public static final boolean BSANS_BUTTON_DEFAULT = true;

	private String title = TITLE_DEFAULT;

	private String content = CONTENT_DEFAULT;

	private String modeContainer;

	private boolean bSansBtonClose = BSANS_BUTTON_DEFAULT;

	private String suffFond = SUFFFOND_DEFAULT;
	
	private boolean draggable = DRAGGABLE_DEFAULT;
	
//	private boolean enable = ENABLE_DEFAULT;
	
	private String position = POSITION_DEFAULT;
	
	private boolean visible = VISIBLE_DEFAULT;
	
	private boolean withCloseButon = WITH_CLOSE_BUTTON_DEFAULT;

	public String getSuffFond() {
		return suffFond;
	}

	public void setSuffFond(String greyBackground) {
		this.suffFond = greyBackground;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
		firePropertyChange("title", null, title);
	}

	public boolean isBSansBtonClose() {
		return bSansBtonClose;
	}

	public void setBSansBtonClose(boolean sansBtonClose) {
		bSansBtonClose = sansBtonClose;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getModeContainer() {
		return modeContainer;
	}

	public void setModeContainer(String modeContainer) {
		this.modeContainer = modeContainer;
	}

	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

//	public boolean isEnable() {
//		return enable;
//	}
//
//	public void setEnable(boolean enable) {
//		this.enable = enable;
//	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public boolean isVisible() {
		return visible;
	}

	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	public boolean isWithCloseButon() {
		return withCloseButon;
	}

	public void setWithCloseButon(boolean withCloseButon) {
		this.withCloseButon = withCloseButon;
	}

	public String[] getEventTypes() {
		return new String[] {EventTypeConstants.ON_CLOSE};
	}
}
