/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Frame extends AbstractContainer {
	
	public static final String TITLE_DEFAULT = "Frame";
	
	public static final String PRINT_TITLE_DEFAULT = "Frame";
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final boolean OPEN_DEFAULT = true;
	
	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final boolean AUTO_RESIZE_PARENT_DEFAULT = false;
//	
//	public static final boolean AUTO_RESIZE_CONTENU_DEFAULT = false;
//	
//	public static final boolean AUTO_RESIZABLE_H_DEFAULT = false;
//	
//	public static final boolean AUTO_RESIZABLE_W_DEFAULT = false;
	
	public static final boolean DYNAMIC_DEFAULT = false;
	
	public static final boolean BOOL_PRINT_DEFAULT = false;
	
	public static final boolean BOOL_MAXI_DEFAULT = false;

	private String title = TITLE_DEFAULT;

	private String position = POSITION_DEFAULT;

	private boolean draggable = DRAGGABLE_DEFAULT;

	private boolean autoResizeParent = AUTO_RESIZE_PARENT_DEFAULT;

	private boolean dynamic = DYNAMIC_DEFAULT;

	private String printTitle = PRINT_TITLE_DEFAULT;

//	private boolean autoResizeContenu = AUTO_RESIZE_CONTENU_DEFAULT;

	private boolean boolPrint = BOOL_PRINT_DEFAULT;

	private boolean boolMaxi = BOOL_MAXI_DEFAULT;
	
	private boolean open = OPEN_DEFAULT;
	
//	private boolean autoResizableH = AUTO_RESIZABLE_H_DEFAULT;
	
//	private boolean autoResizableW = AUTO_RESIZABLE_W_DEFAULT;

	public boolean isAutoResizeParent() {
		return autoResizeParent;
	}

	public void setAutoResizeParent(boolean autoResizeParent) {
		this.autoResizeParent = autoResizeParent;
	}

	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

	public boolean isDynamic() {
		return dynamic;
	}

	public void setDynamic(boolean dynamic) {
		this.dynamic = dynamic;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

//	public boolean isAutoResizeContenu() {
//		return autoResizeContenu;
//	}
//
//	public void setAutoResizeContenu(boolean autoResizeContenu) {
//		this.autoResizeContenu = autoResizeContenu;
//	}

	public boolean isBoolMaxi() {
		return boolMaxi;
	}

	public void setBoolMaxi(boolean boolMaxi) {
		this.boolMaxi = boolMaxi;
	}

	public boolean isBoolPrint() {
		return boolPrint;
	}

	public void setBoolPrint(boolean boolPrint) {
		this.boolPrint = boolPrint;
	}

	public String getPrintTitle() {
		return printTitle;
	}

	public void setPrintTitle(String printTitle) {
		this.printTitle = printTitle;
	}

//	public boolean isAutoResizableH() {
//		return autoResizableH;
//	}
//
//	public void setAutoResizableH(boolean autoResizableH) {
//		this.autoResizableH = autoResizableH;
//	}
//
//	public boolean isAutoResizableW() {
//		return autoResizableW;
//	}
//
//	public void setAutoResizableW(boolean autoResizableW) {
//		this.autoResizableW = autoResizableW;
//	}

	public boolean isOpen() {
		return open;
	}

	public void setOpen(boolean open) {
		this.open = open;
	}
	
	public String[] getEventTypes() {
		return new String[] {EventTypeConstants.ON_SET_DISPLAY};
	}
}
