/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.event;

import java.util.Iterator;
import java.util.Set;

public class Event extends AbstractEventElement {

	public static final boolean ASYNC_DEFAULT = true;
	
	public static final String TYPE_DEFAULT = "remote";
	
	public static final int TIMEOUT_DEFAULT = -1;
	
	// onclick,onblue...
	private String id;

	// EventRefへの参照
	private String ref;

	private String start;

	private String before;

	private String after;

	private String finish;

	private String type = TYPE_DEFAULT;

	private boolean async = ASYNC_DEFAULT;

	private String remoteUrl;

	private int timeout = TIMEOUT_DEFAULT;

	private String onTimeoutError;

	private String confirmDialog;

	private String endDialog;

	private boolean enable = true;

	public Event() {
	}

	public Event(String id) {
		this.id = id;
		this.enable = false;
	}

	public String getAfter() {
		return after;
	}

	public void setAfter(String after) {
		this.after = after;
	}

	public boolean isAsync() {
		return async;
	}

	public void setAsync(boolean async) {
		this.async = async;
	}
	
	public String getBefore() {
		return before;
	}

	public void setBefore(String before) {
		this.before = before;
	}

	public String getFinish() {
		return finish;
	}

	public void setFinish(String finish) {
		this.finish = finish;
	}

	public String getStart() {
		return start;
	}

	public void setStart(String start) {
		this.start = start;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRef() {
		return ref;
	}

	public void setRef(String ref) {
		this.ref = ref;
	}

	public String getRemoteUrl() {
		return remoteUrl;
	}

	public void setRemoteUrl(String remoteUrl) {
		this.remoteUrl = remoteUrl;
	}

	public String getOnTimeoutError() {
		return onTimeoutError;
	}

	public void setOnTimeoutError(String onTimeoutError) {
		this.onTimeoutError = onTimeoutError;
	}

	public int getTimeout() {
		return timeout;
	}

	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

	public String getConfirmDialog() {
		return confirmDialog;
	}

	public void setConfirmDialog(String confirmDialog) {
		this.confirmDialog = confirmDialog;
	}

	public String getEndDialog() {
		return endDialog;
	}

	public void setEndDialog(String endDialog) {
		this.endDialog = endDialog;
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public Param getParam() {
		Param param = (Param) getChildByTypeIdx(Param.class, 0);
		if (param == null) {
			param = new Param(false);
			addChild(param);
		}
		return param;
	}

	public Result getResult() {
		Result result = (Result) getChildByTypeIdx(Result.class, 0);
		if (result == null) {
			result = new Result(false);
			addChild(result);
		}
		return result;
	}

	public void getRelatedObjNames(Set resultSet) {
		Param param = (Param) getChildByTypeIdx(Param.class, 0);
		if (param != null) {
			for (Iterator it = param.getSourcesIt(); it != null && it.hasNext();) {
				Source source = (Source) it.next();
				if (source.getObj() != null) {
					resultSet.add(source.getObj());
				}
			}
		}
		
		Result result = (Result) getChildByTypeIdx(Result.class, 0);
		if (result != null) {
			for (Iterator it = result.getTargetsIt(); it != null && it.hasNext();) {
				Target target = (Target) it.next();
				if (target.getOut() != null) {
					resultSet.add(target.getOut());
				}
			}
		}
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
	}
	
	public String toString() {
		return "";
	}
}
