/*******************************************************************************
 * ManjyuCalendar
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.calendar;

import java.util.Date;

/**
 * Date Utility for Java.
 * 
 * @author Toshiki Iga
 */
public class ManjyuDateUtil {
	/**
	 * Hide Constructor.
	 */
	private ManjyuDateUtil() {
	}

	/**
	 * Get current date.
	 * 
	 * @return current date object.
	 */
	public static Date getNow() {
		return new Date();
	}

	/**
	 * Get date with specified condition.
	 *  
	 * @param year Year value. 1 origin.
	 * @param month Month value. 1 origin.
	 * @param day Day value. 1 origin.
	 * @return Date object of specified value.
	 */
	public static Date getDate(final int year, final int month, final int day) {
		return ManjyuCalendarUtil.getCalendar(year, month, day).getTime();
	}

	/**
	 * Clear hour, minute, second part.
	 *
	 * @param date Target date object to clear.
	 */
	@SuppressWarnings("deprecation")
	public static void clearHhmmss(final Date date) {
		final int year = date.getYear();
		final int month = date.getMonth();
		final int day = date.getDate();

		// Clear date fields for milliseconds value.
		date.setTime(0);

		// Set year, month, date (day of month), and hours. 
		date.setYear(year);
		date.setMonth(month);
		// Date means day of month.
		date.setDate(day);
		date.setHours(0);
		date.setMinutes(0);
		date.setSeconds(0);
	}
}
