print "Loading mod: time_reminders v2016-10-05 (http://forum.worldoftanks.eu/index.php?/topic/503548-)"
import BigWorld, ResMgr
from PlayerEvents import g_playerEvents
from constants import ARENA_PERIOD
from gui.app_loader import g_appLoader
from gui.app_loader.settings import GUI_GLOBAL_SPACE_ID as _SPACE_ID
from helpers import getClientLanguage
from os import listdir
from os.path import isdir, isfile, join
from debug_utils import LOG_NOTE

def MYLOG(message, *args):
    LOG_NOTE(message, *args)
    pass

mypath = ResMgr.openSection('../paths.xml')['Paths'].values()[0:2][0].asString + '/scripts/client/gui/mods/time_reminders/'
lang = getClientLanguage()

timeouts_definition = []
if isdir(mypath + lang):
    for f in listdir(mypath + lang):
        if isfile(join(mypath + lang,f)):
            parts = f.split(".")
            if len(parts)==2 and parts[0].isdigit() and parts[1]=="mp3":
                timeouts_definition.append(int(parts[0]))

timeouts_definition = sorted(timeouts_definition)
MYLOG(mypath + lang + " " + str(timeouts_definition))

callback = None

def myPe_onArenaPeriodChange(period, periodEndTime, periodLength, *args):
    MYLOG("onArenaPeriodChange(%d)" % period)
    if g_appLoader.getSpaceID() is _SPACE_ID.BATTLE and period is ARENA_PERIOD.BATTLE and timeouts_definition:
        timeouts = []
        timeouts.extend(timeouts_definition)
        setupTimeout(timeouts, periodEndTime)

g_playerEvents.onArenaPeriodChange += myPe_onArenaPeriodChange

def my_onGUISpaceChanged(guiSpace, *args):
    global callback
    MYLOG("onGUISpaceChanged(%d)" % guiSpace)
    if callback:
        BigWorld.cancelCallback(callback)
        callback = None
    
g_appLoader.onGUISpaceEntered += my_onGUISpaceChanged

def setupTimeout(timeouts, battle_ends):
    global callback
    if timeouts:
        seconds_left = battle_ends - BigWorld.serverTime() - timeouts[-1]
        if seconds_left > 0:
            callback = BigWorld.callback(seconds_left, lambda: playTimeout(timeouts, battle_ends))
        else:
            setupTimeout(timeouts[:-1], battle_ends)
    else:
        callback = None

import subprocess

def playExtSound(mp3):
    try:
        startupinfo = subprocess.STARTUPINFO()
        startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
        startupinfo.wShowWindow = subprocess.SW_HIDE
        subprocess.Popen([mypath + "cmdmp3.exe",
                          mypath + mp3], startupinfo=startupinfo)
    except:
        pass
        
def playTimeout(timeouts, battle_ends):
    playExtSound(lang + "/" + str(timeouts.pop()) + ".mp3")
    setupTimeout(timeouts, battle_ends)

# from gui.Scaleform.Battle import Battle
# 
# def Battle_showSixthSenseIndicator(self, isShow):
#     MYLOG("Battle_showSixthSenseIndicator(%d)" % isShow)
#     old_Battle_showSixthSenseIndicator(self, isShow)
#     if isShow:
#         playExtSound("SixthSense.mp3")
# 
# old_Battle_showSixthSenseIndicator = Battle._showSixthSenseIndicator
# Battle._showSixthSenseIndicator = Battle_showSixthSenseIndicator
# 
# def Battle_setFireInVehicle(self, bool):
#     MYLOG("Battle_setFireInVehicle(%d)" % bool)
#     old_Battle_setFireInVehicle(self, bool)
#     if bool:
#         playExtSound('TankOnFire.mp3')
# 
# old_Battle_setFireInVehicle = Battle._setFireInVehicle
# Battle._setFireInVehicle = Battle_setFireInVehicle
