/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.lepidolite.dao;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.lepidolite.dao.DaoException;

public class ConnectionProxy {
    private Connection conn;
    private Set<Statement> openedStatements;
    private Set<ResultSet> openedResultSets;
    private Object proxy;

    private ConnectionProxy(Connection conn) {
        this.conn = conn;
        this.openedStatements = new HashSet<Statement>();
        this.openedResultSets = new HashSet<ResultSet>();
        this.proxy = Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler());
    }

    public static Connection createProxy(Connection conn) {
        ConnectionProxy pc = new ConnectionProxy(conn);
        return (Connection)pc.proxy;
    }

    private Object send(Object target, Method m, Object[] args) throws Throwable {
        try {
            return m.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void remove(Object o) {
        if (o instanceof ResultSet) {
            this.openedResultSets.remove(o);
        } else if (o instanceof Statement) {
            this.openedStatements.remove(o);
        } else {
            throw new IllegalArgumentException("bad class:" + o);
        }
    }

    private void closeAll() {
        for (ResultSet rs : this.openedResultSets) {
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                throw new DaoException("ResultSet\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
            }
        }
        for (Statement ps : this.openedStatements) {
            try {
                ps.close();
            }
            catch (SQLException sqle) {
                throw new DaoException("Statement\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private ConnectionHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                ConnectionProxy.this.closeAll();
            } else if (method.getName().equals("equals") && args.length == 1) {
                if (proxy == args[0]) {
                    return true;
                }
                return false;
            }
            Object o = ConnectionProxy.this.send(ConnectionProxy.this.conn, method, args);
            Class<?> returnType = method.getReturnType();
            if (DatabaseMetaData.class.isAssignableFrom(returnType)) {
                o = new Delegate(proxy, o, DatabaseMetaData.class).proxy;
            } else if (Statement.class.isAssignableFrom(returnType)) {
                ConnectionProxy.this.openedStatements.add((Statement)o);
                o = new Delegate(proxy, o, returnType).proxy;
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Delegate
    implements InvocationHandler {
        private Object parent;
        private Object proxy;
        private Object original;

        private Delegate(Object parent, Object original, Class<?> c) {
            this.parent = parent;
            this.original = original;
            this.proxy = Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                ConnectionProxy.this.remove(this.original);
            }
            Object o = ConnectionProxy.this.send(this.original, method, args);
            Class<?> returnType = method.getReturnType();
            if (ResultSet.class.isAssignableFrom(returnType)) {
                ConnectionProxy.this.openedResultSets.add((ResultSet)o);
                o = (ConnectionProxy)ConnectionProxy.this.new Delegate((Object)proxy, (Object)o, returnType).proxy;
            }
            if (this.original instanceof ResultSet && method.getName().equals("getStatement")) {
                o = this.parent;
            }
            if (Connection.class.isAssignableFrom(returnType)) {
                o = this.parent;
            }
            return o;
        }
    }
}

