/* $Id: Statistics.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 * create: 2004/07/27
 * (c)2004 Lavans Networks Inc. All Rights Reserved.
 */
package com.lavans.util.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import com.lavans.util.BaseClass;

/**
 * @author dobashi
 * @version 1.00
 */
public class Statistics extends BaseClass {
	/**
	 * SQLTimeData΂ɂĕۑMap.
	 */
	private Map sqlMap = null;
	
	/**
	 * SingletoñCX^XB
	 */
	private static Statistics instance= new Statistics();

	private Statistics(){
		sqlMap = new HashMap();	
	}
	
	public static Statistics getInstance(){
		return instance;
	}
	
	/**
	 * vf[^ǉB
	 * @param sql
	 * @param costTime
	 */
	public void addData(String sql, long costTime, String classname){
		StatRecord record = (StatRecord)sqlMap.get(sql);
		if(record==null){
			record = new StatRecord();
			sqlMap.put(sql,record);
			record.setSql(sql);
		}
		record.callCountUp();
		record.addTotalCostTime(costTime);
		// executeĂяoNX#\bh擾
		String method = logger.getMethodName(classname);
		record.addMethodNames(method);
	}
	
	/**
	 * vsԕʓvB
	 * @return
	 */
	public List getStatInfoByTotal(){
		return getStatInfoByTotal(0,sqlMap.size());
	}
	
	/**
	 * vsԕʓvB
	 * @param fromIndex
	 * @param toIndex
	 * @return
	 */
	public List getStatInfoByTotal(int fromIndex, int toIndex){
		List list = new ArrayList(sqlMap.values());
		Collections.sort(list, new Comparator(){
			public int compare(Object o1, Object o2){
				int result = -1;
				StatRecord r1 = (StatRecord)o1;
				StatRecord r2 = (StatRecord)o2;
				if(r1.getTotalCostTime() > r2.getTotalCostTime()){
					result=1;
				}else if(r1.getTotalCostTime() == r2.getTotalCostTime()){
					result=0;
				}
				return result;
			}
		}
		);

		return list.subList(fromIndex, toIndex);
	}

	/**
	 * vsԕʓvB
	 * @return
	 */
	public List getStatInfoByAverage(){
		return getStatInfoByAverage(0,sqlMap.size());
	}

	/**
	 * ώsԕʓvB
	 * @param fromIndex
	 * @param toIndex
	 * @return
	 */
	public List getStatInfoByAverage(int fromIndex, int toIndex){
		List list = new ArrayList(sqlMap.values());
		Collections.sort(list, new Comparator(){
			public int compare(Object o1, Object o2){
				int result = -1;
				StatRecord r1 = (StatRecord)o1;
				StatRecord r2 = (StatRecord)o2;
				if(r1.getAverage() > r2.getAverage()){
					result=1;
				}else if(r1.getAverage() == r2.getAverage()){
					result=0;
				}
				return result;
			}
		}
		);

		return list.subList(fromIndex, toIndex);
	}
}

 
