/* $Id: Browser.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 * 쐬: 2004/03/13
 *
 */
package com.lavans.util.browser;


import java.util.Properties;

import com.lavans.util.BaseClass;

/**
 * uEUۃNXB
 * uEUNX̌pc[͊Kw\ƂBeuEUNX
 * ڍ׏quEUNX܂鎖łB
 * Browser
 *  - Mozilla
 *     - FireFox
 *     - FireBird
 *     - Mozilla
 *     - Netscape6
 *     - Netscape4
 *  - MSIE
 *  - DoCoMo
 *     - 211i
 *     - 504i
 *     - F2000
 *  - EZweb
 *  - EZweb_WAP2
 *  - Vodafone
 * ŁAFireFoxNXMozillaNXpĂ̂ňȉ̎藧B
 * (FireFox instanceof Mozilla) == true;
 * ܂AMozillaNXFireFox`Netscape4܂ł̊eCX^X
 * ܂ĂBis-a֌W==has-a֌WƂȂB
 * eNXUSER-AGNETuEUNX肷ۂɁA܂qNXꗗ
 * YuEU邩ǂׁAȂΎNXԂB
 * qNXuEÚARXgN^ŎqNX̃CX^Xꗗ
 * 擾ĂB(҂BrowserCheckerNXɗȂ̂ŁA
 * static{}ubNɏĂǂݍ܂Ȃ)B
 *
 * ̐݌vɂAΉ̃uEUoꍇ͊eO[v̏ʃNXԂB
 * ႦNetscape100ANZXꍇȂAMozillaNXԂ鎖ɂȂB
 * 
 * VuEUNXǉꍇɂ́AeNX̃RXgN^ɓo^̂YȂ悤ɁB
 * @author dobashi
 *
 */
public class Browser extends BaseClass {
	private static final String USER_AGENT 		= "user_agent";
	private static final String VENDOR	 		= "vendor";
	private static final String WIDTH 			= "width";
	private static final String HEIGHT 			= "height";
	private static final String WALLPAPER_WIDTH 	= "wallpaperWidth";
	private static final String WALLPAPER_HEIGHT	= "wallpaperHeight";
	private static final String CAN_GIF_VIEW 	= "canGifView";
	private static final String CAN_PNG_VIEW		= "canPngView";
	private static final String CAN_JPG_VIEW		= "canJpgView";
	private static final String CAN_FLASH_VIEW 	= "canFlashView";
	private static final String CAN_IAPPLI_VIEW	= "canIAppliView";
	private static final String CAN_IMOTION_VIEW	= "canIMotionView";

	/** ʁBdesktop/phone/pda. */
	private String type = null;
	/** @햼 */
	private String name = null;
	/** [U[G[WFg */
	private String userAgent = null;
	/** [J[ */
	private String vendor = null;

	/** gif\\ */
	private boolean canGifView;
	/** jpg\\ */
	private boolean canJpgView;
	/** png\\ */
	private boolean canPngView;
	/** Flash\\ */
	private boolean canFlashView;
	/** iAppli\\ */
	private boolean canIAppliView;
	/** iMotion\\ */
	private boolean canIMotionView;
	
	// ̑̃vpeBjava.util.PropertiesɊi[B
	private Properties props = new Properties();
	
	/** 摜\TCY */
	private int width=0;
	/** 摜\TCYc */
	private int height=0;
	/** ǎ\TCY */
	private int wallpaperWidth=0;
	/** ǎ\TCYc */
	private int wallpaperHeight=0;
	
	public String toString(){
		return name +":"+ userAgent +" size:"+ width +"x"+ height + " ǎ:"+ wallpaperWidth +"x"+ wallpaperHeight
		+" gif:"+ marubatsu(canGifView) +" jpg:"+ marubatsu(canJpgView) +" png:"+ marubatsu(canPngView) 
		+" flash:"+ marubatsu(canFlashView) +" iappli:"+ marubatsu(canIAppliView) +" imotion:"+ marubatsu(canIMotionView)
		+" "+ props.toString();
		//+" imerody16:"+ marubatsu(canIMusic16View)+" imerody32:"+ marubatsu(canIMusic32View)+" imerody40:"+ marubatsu(canIMusic40View);
	}
	
	private String marubatsu(boolean b){
		return b?"":"~";
	}
	/**
	 * ݒ
	 * @param name
	 * @param value
	 */
	public void setAttribute(String name, String value){
		if(USER_AGENT.equals(name)){
			userAgent = value;
		}else if(VENDOR.equals(name)){
			vendor = value;
		}else if(WIDTH.equals(name)){
			width = Integer.parseInt(value);
		}else if(HEIGHT.equals(name)){
			height = Integer.parseInt(value);
		}else if(WALLPAPER_WIDTH.equals(name)){
			wallpaperWidth = Integer.parseInt(value);
		}else if(WALLPAPER_HEIGHT.equals(name)){
			wallpaperHeight = Integer.parseInt(value);
		}else if(CAN_GIF_VIEW.equals(name)){
			canGifView = Boolean.valueOf(value).booleanValue();
		}else if(CAN_JPG_VIEW.equals(name)){
			canJpgView = Boolean.valueOf(value).booleanValue();
		}else if(CAN_PNG_VIEW.equals(name)){
			canPngView = Boolean.valueOf(value).booleanValue();
		}else if(CAN_FLASH_VIEW.equals(name)){
			canFlashView = Boolean.valueOf(value).booleanValue();
		}else if(CAN_IAPPLI_VIEW.equals(name)){
			canIAppliView = Boolean.valueOf(value).booleanValue();
		}else if(CAN_IMOTION_VIEW.equals(name)){
			canIMotionView = Boolean.valueOf(value).booleanValue();
		}else{
			// ̑
			props.setProperty(name,value);
		}
	}
	
	/**
	 * gif\ł邩ǂ擾B
	 * @return
	 */
	public boolean canGifView() {
		return canGifView;
	}

	/**
	 * gif\ł邩ǂZbgB
	 * @param canGifView
	 */
	protected void setCanGifView(boolean canGifView) {
		this.canGifView = canGifView;
	}

	/**
	 * png\ł邩ǂ擾B
	 * @return
	 */
	public boolean canPngView() {
		return canPngView;
	}

	/**
	 * png\ł邩ǂZbgB
	 * @param canGifView
	 */
	public void setCanPngView(boolean canPngView) {
		this.canPngView = canPngView;
	}

	/**
	 * @return
	 */
	public boolean canFlashView() {
		return canFlashView;
	}

	/**
	 * @param b
	 */
	public void setCanFlashView(boolean b) {
		canFlashView = b;
	}

	/**
	 * @return
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * @param i
	 */
	public void setHeight(int i) {
		height = i;
	}

	/**
	 * @return
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @param i
	 */
	public void setWidth(int i) {
		width = i;
	}

	/**
	 * @return
	 */
	public int getWallpaperHeight() {
		return wallpaperHeight;
	}

	/**
	 * @return
	 */
	public int getWallpaperWidth() {
		return wallpaperWidth;
	}

	/**
	 * @param i
	 */
	public void setWallpaperHeight(int i) {
		wallpaperHeight = i;
	}

	/**
	 * @param i
	 */
	public void setWallpaperWidth(int i) {
		wallpaperWidth = i;
	}

	/**
	 * @return
	 */
	public boolean canJpgView() {
		return canJpgView;
	}

	/**
	 * @param b
	 */
	public void setCanJpgView(boolean b) {
		canJpgView = b;
	}

	/**
	 * @return
	 */
	public boolean canIAppliView() {
		return canIAppliView;
	}

	/**
	 * @param b
	 */
	public void setCanIAppliView(boolean b) {
		canIAppliView = b;
	}

	/**
	 * @return
	 */
	public boolean canIMotionView() {
		return canIMotionView;
	}

	/**
	 * @param b
	 */
	public void setCanIMotionView(boolean b) {
		canIMotionView = b;
	}

	/**
	 * 
	 * @return
	 */
	public String getProperty(String key){
		return props.getProperty(key);
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @param string
	 */
	public void setUserAgent(String string) {
		userAgent = string;
	}

	/**
	 * @return
	 */
	public String getVendor() {
		return vendor;
	}

	/**
	 * @param string
	 */
	public void setVendor(String string) {
		vendor = string;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
		if(type==null){
			type="";
		}
	}

}
