﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using com.andoutomo.kybernetes.view;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.control;
using System.Reflection;

namespace WindowsFormsApplication1
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            KybernetesLogger.Log.debug("------------run version " + AppInfoContainer.VersionNo + "----------------");

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            setAppInfoContainer();


            KybernetesLogger.CurrentLogMode = SettingDataAccessor.getObject.getLogMode();
            //KybernetesLogger.CurrentLogMode = LogMode.Error;
            BaseForm form = new BaseForm();

            Application.Run(CmdDispatcher.getDispatcher(form).getForm());

        }
        static void setAppInfoContainer()
        {
            //AssemblyTitleの取得
            AssemblyTitleAttribute asmttl = (System.Reflection.AssemblyTitleAttribute)
                Attribute.GetCustomAttribute(Assembly.GetExecutingAssembly(), typeof(AssemblyTitleAttribute));
            AppInfoContainer.Title = asmttl.Title;
            //AssemblyDescriptionの取得
            AssemblyDescriptionAttribute asmdc = (System.Reflection.AssemblyDescriptionAttribute)
                Attribute.GetCustomAttribute(Assembly.GetExecutingAssembly(), typeof(AssemblyDescriptionAttribute));
            AppInfoContainer.Description = asmdc.Description;
            //AssemblyCopyrightの取得
            AssemblyCopyrightAttribute asmcpy = (System.Reflection.AssemblyCopyrightAttribute)
                Attribute.GetCustomAttribute(Assembly.GetExecutingAssembly(), typeof(AssemblyCopyrightAttribute));
            AppInfoContainer.CopyRight = asmcpy.Copyright;
            //自分自身のAssemblyを取得
            System.Version ver = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
            AppInfoContainer.VersionNo = ver.ToString();
        }
    }

}
