﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.connection;


namespace com.andoutomo.kybernetes.view
{
    public partial class TimeAreaSetting : Form
    {
        public TimeAreaSetting()
        {
            InitializeComponent();
        }
        private List<TimeAreaData> innerList;
        private string targetForChg;

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string target = this.TimeareaListBox.SelectedItem.ToString().Substring(0, 1);
            var rawdata = from data in innerList where data.AreaStr == target select data;
            foreach (TimeAreaData innerData in rawdata)
            {
                this.txtArea.Text = innerData.AreaStr;
                this.targetForChg = innerData.AreaStr;
                this.txtFrom.Text = innerData.StartTime.ToString();
                this.txtTo.Text = innerData.EndTime.ToString();
            }
        }
        public void setTimeareaList(List<TimeAreaData> dataList)
        {
            TimeareaListBox.Items.Clear();
            innerList = dataList;

            foreach (TimeAreaData data in innerList)
            {
                TimeareaListBox.Items.Add(data.TextForDropDown);
            }
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            List<MultiSQLRunnningBean> sqlList = new List<MultiSQLRunnningBean>();
            sqlList.Add(new MultiSQLRunnningBean(SqlDictionary.clearTimeArea, new List<object>()));
            foreach (TimeAreaData innerData in innerList)
            {
                List<object> argList = new List<object>();
                argList.Add(innerData.AreaStr);
                argList.Add(innerData.StartTime);
                argList.Add(innerData.EndTime);
                
                sqlList.Add(new MultiSQLRunnningBean(SqlDictionary.insertTimeArea, argList));
            }

            TaskDBConnection.Connection.updateData(sqlList);

            this.Close();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            if (txtArea.Text == string.Empty) return;
            var rawdata = from data in innerList where data.AreaStr == this.txtArea.Text select data;
            foreach (TimeAreaData dummy in rawdata)
            {
                //既にデータがある場合は何もせず終了
                return;
            }
            TimeAreaData newData = new TimeAreaData();
            newData.AreaStr=txtArea.Text;
            newData.StartTime=new TimeComponent(txtFrom.Text);
            newData.EndTime= new TimeComponent(txtTo.Text);

            innerList.Add(newData);
            setTimeareaList(innerList);
        }

        private void btnAply_Click(object sender, EventArgs e)
        {

            var rawdata = from data in innerList where data.AreaStr == this.targetForChg select data;

            foreach (TimeAreaData updData in rawdata)
            {
                if (string.IsNullOrEmpty(this.txtArea.Text))
                {
                    innerList.Remove(updData);
                    break;
                }
                else
                {
                    updData.AreaStr = this.txtArea.Text.ToUpper();
                    updData.StartTime = new TimeComponent(this.txtFrom.Text);
                    updData.EndTime = new TimeComponent(this.txtTo.Text);
                }
            }
            setTimeareaList(innerList);
        }
    }
}
