﻿using System.Windows.Forms;
using System.Drawing;
using com.andoutomo.kybernetes.data.DAO;
using System;

namespace com.andoutomo.kybernetes.view
{
    public class PanelController
    {
        public static displayMode mode;


        private BaseForm baseForm;
        public PanelController(BaseForm form)
        {
            this.baseForm = form;
        }
        public Panel createRow(int point,TaskData data)
        {
            Panel rowPanel=new Panel();
            Color frColor = Color.White;
            if (!string.IsNullOrEmpty(data.Category))
            {
                frColor = Color.FromArgb(data.FrColor);
            }
            //Color bgColor = Color.FromArgb(data.BgColor);
            FontStyle style;
            FontStyle timeStyle;
            float fontsize;
            int rowsize;

            if (data.ForecastMin >= 90|| data.RealMin >=90)
            {
                fontsize = 10F;
                rowsize = 24;
                
                if (data.isComplete)
                {
                    style = FontStyle.Strikeout;
                    timeStyle = FontStyle.Strikeout;
                    frColor = Color.Gray;
                }
                else if (data.StartTime.IsValid)
                {
                    timeStyle = FontStyle.Underline;
                    style = FontStyle.Underline | FontStyle.Bold;
                    rowsize += 1;
                }
                else if (data.ForecastMin >= 120 || data.RealMin >=120)
                {
                    if (data.StartTime.IsValid)
                    {
                        timeStyle = FontStyle.Underline;
                        style = FontStyle.Underline | FontStyle.Bold;
                        rowsize += 1;
                    }
                    else
                    {
                        style = FontStyle.Regular;
                        timeStyle = FontStyle.Bold;
                    }
                }
                else
                {
                    timeStyle = FontStyle.Regular;
                    style = FontStyle.Regular;
                }
            }
            else if (data.ForecastMin >= 60 || data.RealMin >= 60)
            {
                fontsize = 9F;
                rowsize = 20;

                if (data.isComplete)
                {
                    timeStyle = FontStyle.Strikeout;
                    style = FontStyle.Strikeout;
                    frColor = Color.Gray;
                }
                else if (data.StartTime.IsValid)
                {
                    timeStyle = FontStyle.Underline;
                    style = FontStyle.Underline | FontStyle.Bold;
                    rowsize += 1;
                }
                else
                {
                    timeStyle = FontStyle.Regular;
                    style = FontStyle.Regular;
                }

            }
            else
            {
                fontsize = 9F;
                rowsize = 16;

                if (data.isComplete)
                {
                    timeStyle = FontStyle.Strikeout;
                    style = FontStyle.Strikeout;
                    frColor = Color.Gray;
                }
                else if (data.StartTime.IsValid)
                {
                    timeStyle = FontStyle.Underline;
                    style = FontStyle.Underline| FontStyle.Bold;
                    rowsize += 1;
                }
                else
                {
                    timeStyle = FontStyle.Regular;
                    style = FontStyle.Regular;
                }

            }
            //全体サイズからContentの長さを決める。
            
            int wkPanelSize = baseForm.getPanelSize();

            int wkContentAdditional = wkPanelSize - 825;
            if (wkContentAdditional < 0) wkContentAdditional = 0;
            //int wkContentSize = wkPanelSize - 689;
            int wkDelaySize = 395+wkContentAdditional;
            
            sortID = data.SortID;
            //rowPanel.Controls.Add(new CustomLabel(data.Indicator, frColor, bgColor, FontStyle.Regular, 9F, 0, 21, rowsize,ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel(data.SortID.ToString(), frColor,  FontStyle.Regular, 9F, 0, 41, rowsize, ContentAlignment.MiddleRight));
            rowPanel.Controls.Add(new CustomLabel(data.DoDate.getDateString(), frColor,  style, 9F, 40, 56, rowsize,ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel(data.DoDate.getDowStr(), frColor,  style, 9F, 95, 26, rowsize,ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel(data.TimeArea, frColor,  style, 9F, 120, 21, rowsize,ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel(data.Category, frColor,  style, 9F, 140, 81, rowsize));

            rowPanel.Controls.Add(new CustomLabel(data.Contents, frColor,  style, 9F, 220, 175 + wkContentAdditional, rowsize));

            rowPanel.Controls.Add(new CustomLabel(data.getForcastHourStr, frColor,  timeStyle, fontsize, wkDelaySize, 51, rowsize, ContentAlignment.MiddleRight));
            rowPanel.Controls.Add(new CustomLabel(data.ForecastMin.ToString(), frColor,  timeStyle, fontsize, wkDelaySize + 50, 51, rowsize, ContentAlignment.MiddleRight));
            rowPanel.Controls.Add(new CustomLabel(data.RealMin.ToString(), frColor,  timeStyle, fontsize, wkDelaySize + 100, 51, rowsize, ContentAlignment.MiddleRight));
            rowPanel.Controls.Add(new CustomLabel(data.StartTime.ToString(), frColor,  style, 9F, wkDelaySize + 150, 61, rowsize, ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel(data.EndTime.ToString(), frColor,  style, 9F, wkDelaySize + 210, 61, rowsize, ContentAlignment.MiddleCenter));

            rowPanel.Controls.Add(new CustomLabel(data.Project, frColor,  style, 9F, wkDelaySize + 270, 81, rowsize));
            rowPanel.Controls.Add(new CustomLabel((data.IsRepeat == 1 ? "R" : ""), frColor,  style, 9F, wkDelaySize + 350, 21, rowsize, ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel((data.HasComment == 1 ? "*" : ""), frColor,  style, 9F, wkDelaySize + 370, 21, rowsize, ContentAlignment.MiddleCenter));
            rowPanel.Controls.Add(new CustomLabel((string.IsNullOrEmpty(data.Tags) ? "" : "*"), frColor,  style, 9F, wkDelaySize + 390, 21, rowsize, ContentAlignment.MiddleCenter, data.Tags));
            
            //rowPanel.Controls.Add(new CustomLabel(data.SortID.ToString(), frColor, bgColor, FontStyle.Regular, 9F, wkDelaySize + 410, 41, rowsize, ContentAlignment.MiddleRight));
  
            
            rowPanel.Location = new Point(0, point);
            rowPanel.Size = new Size(825 + wkContentAdditional, rowsize);
            //rowPanel.BorderStyle = BorderStyle.FixedSingle;
            

            rowPanel.TabStop = false;
            foreach (Control eachControls in rowPanel.Controls)
            {
                eachControls.DoubleClick += new System.EventHandler(rowPanelDblClickAction);
            }

            return rowPanel;
        }
        private int sortID;

        private void rowPanelDblClickAction(object sender, EventArgs args)
        {
            baseForm.AddIDToText(sortID.ToString());
        }
        
    }

    public class CustomLabel:Label
    {
        public CustomLabel(string text,Color FRColor,FontStyle style,float size,int location,int colsize,int rowSize)
        {
            //innerLabel = new Label();
            //可変要素
            this.Text = text;
            this.BackColor = Color.Transparent;
            this.ForeColor = FRColor;
            this.Font = new Font("MS UI Gothic", size, style, GraphicsUnit.Point, 128);
            this.Location = new Point(location, 0);
            this.Size = new Size(colsize, rowSize);

            //固定要素
            this.BorderStyle = System.Windows.Forms.BorderStyle.None;
            

            this.TabIndex = 0;
            this.TextAlign = ContentAlignment.MiddleLeft;
            this.Anchor = (AnchorStyles.Left | AnchorStyles.Top);
        }
        public CustomLabel(string text, Color FRColor,  FontStyle style, float size, int location, int colsize, int rowSize, ContentAlignment align)
            :this(text,FRColor,style,size,location,colsize,rowSize)
        {
            this.TextAlign = align;
        }

        public CustomLabel(string text, Color FRColor,  FontStyle style, float size, int location, int colsize, int rowSize, ContentAlignment align, string tooltipStr)
            : this(text, FRColor,  style, size, location, colsize, rowSize,align)
        {
            ToolTip pop = new ToolTip();
            //ToolTipの設定を行う
            //ToolTipが表示されるまでの時間
            pop.InitialDelay = 500;
            //ToolTipが表示されている時に、別のToolTipを表示するまでの時間
            pop.ReshowDelay = 100;
            //ToolTipを表示する時間
            pop.AutoPopDelay = 4000;
            //フォームがアクティブでない時でもToolTipを表示する
            pop.ShowAlways = false;

            //このオブジェクトにToolTipが表示されるようにする
            pop.SetToolTip(this, tooltipStr);
            

        }
    }
    public enum displayMode
    {
        planning,
        result,
    }
}
