﻿using System;
using System.Windows.Forms;

namespace com.andoutomo.kybernetes.view
{
    public partial class InputBox : Form
    {
        public InputBox()
        {
            InitializeComponent();
        }

        public InputBox(string prompt)
            : this()
        {
            this.lblPrompt.Text = prompt;
        }
        public InputBox(string prompt, string defaultData)
            :this(prompt)
        {
            this.txtDialogInput.Text = defaultData;
        }


        private void btnOK_Click(object sender, EventArgs e)
        {
            turnCollect();
        }

        private void turnCollect()
        {
            this.DialogResult = DialogResult.OK;
            ((BaseForm)Owner).InputDialogData = txtDialogInput.Text;
            this.Close();
        }

        private void turnCancel()
        {
            this.DialogResult = DialogResult.Cancel;
            ((BaseForm)Owner).InputDialogData = string.Empty;
            this.Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            turnCancel();
        }

        private void textBox_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Enter:
                    turnCollect();
                    break;

                case Keys.Space:
                    if (e.Control)
                    {
                        e.SuppressKeyPress = true;
                        if (txtDialogInput.ImeMode == ImeMode.Off)
                        {
                            txtDialogInput.ImeMode = ImeMode.On;
                        }
                        else
                        {
                            txtDialogInput.ImeMode = ImeMode.Off;
                        }
                    }
                    break;
                case Keys.Escape:
                    turnCancel();
                    break;
            }
        }
    }
}
