﻿using System.Collections.Generic;
using System.Data.SQLite;
using com.andoutomo.kybernetes.control;

namespace com.andoutomo.kybernetes.data.connection
{
    delegate void TransitData(SQLiteDataReader reader);

    abstract class DBConnection
    {
        public abstract string targetDbFile();

        /// <summary>
        /// データの参照を行う。
        /// </summary>
        /// <param name="sql">SQL</param>
        /// <param name="parameters">追加パラメータ</param>
        /// <param name="transition">delegateロジック。呼び出し元で参照結果を加工するメソッド</param>
        public void selectData(string sql, List<object> parameters, TransitData transition)
        {
            KybernetesLogger.Log.debug("SQL:" + sql);
            try
            {
                using (var conn = new SQLiteConnection("Data Source=" + targetDbFile()))
                {
                    conn.Open();
                    using (SQLiteCommand command = conn.CreateCommand())
                    {
                        command.CommandText = sql;
                        foreach (object arg in parameters)
                        {
                            SQLiteParameter param = command.CreateParameter();
                            param.Value = arg;
                            command.Parameters.Add(param);
                        }
                        using (SQLiteDataReader reader = command.ExecuteReader())
                        {
                            transition(reader);
                        }
                    }
                    conn.Close();
                }
            }
            catch (SQLiteException se)
            {
                throw new KybernetesApplicationException(se);

            }
        }
        public void selectData(string sql, TransitData transition)
        {
            selectData(sql,new List<object>(),transition);
        }
        
        /// <summary>
        /// データの更新を行う。
        /// </summary>
        /// <param name="sql">更新用SQL</param>
        /// <param name="parameters">更新パラメータ</param>
        /// <returns>成功すればtrue、失敗の場合はFalse</returns>
        public bool updateData(string sql, List<object> parameters)
        {
            KybernetesLogger.Log.debug("SQL:" + sql);
            try
            {
                using (var conn = new SQLiteConnection("Data Source=" + targetDbFile()))
                {
                    conn.Open();
                    using (SQLiteTransaction sqlt = conn.BeginTransaction())
                    {
                        using (SQLiteCommand command = conn.CreateCommand())
                        {
                            command.CommandText = sql;
                            foreach (object arg in parameters)
                            {
                                SQLiteParameter param = command.CreateParameter();
                                param.Value = arg;
                                command.Parameters.Add(param);
                            }
                            int result = command.ExecuteNonQuery();
                        }
                        sqlt.Commit();
                    }
                    conn.Close();
                }
                return true;
            }
            catch (SQLiteException se)
            {
                KybernetesLogger.Log.error(se.StackTrace);
                return false;
            }
        }
        public bool updateData(string sql)
        {
            return updateData(sql, new List<object>());
        }
        /// <summary>
        /// データの更新を行う。リストを使用して一気に実施する。
        /// </summary>
        /// <param name="updateList">更新対象リスト</param>
        /// <returns></returns>
        public bool updateData(List<MultiSQLRunnningBean> updateList)
        {
            try
            {
                using (var conn = new SQLiteConnection("Data Source=" + targetDbFile()))
                {
                    conn.Open();
                    using (SQLiteTransaction sqlt = conn.BeginTransaction())
                    {
                        foreach (MultiSQLRunnningBean bean in updateList)
                        {
                            KybernetesLogger.Log.debug("SQL:" + bean.SQL);
                            using (SQLiteCommand command = conn.CreateCommand())
                            {
                                command.CommandText = bean.SQL;
                                foreach (object arg in bean.Parameters)
                                {
                                    SQLiteParameter param = command.CreateParameter();
                                    param.Value = arg;
                                    command.Parameters.Add(param);
                                }
                                int result = command.ExecuteNonQuery();
                            }
                        }
                        sqlt.Commit();
                    }
                    conn.Close();
                }
                return true;
            }
            catch (SQLiteException se)
            {
                KybernetesLogger.Log.error(se.StackTrace);
                return false;
            }
        }

    }
    /// <summary>
    /// 複数連続SQL実行時に、同一トランザクション内で実施できるようにデータを複数格納する。
    /// </summary>
    public class MultiSQLRunnningBean
    {
        private string sql;
        private List<object> parameters;
        public string SQL
        {
            get { return sql; }
        }
        public List<object> Parameters
        {
            get { return parameters; }
        }

        public MultiSQLRunnningBean(string _sql, List<object> _parameters)
        {
            this.sql = _sql;
            this.parameters = _parameters;
        }
    }
}
