﻿using System;

namespace com.andoutomo.kybernetes.control
{
    public class KybernetesApplicationException : Exception
    {
        private Exception e;

        /// <summary>
        /// 業務エラー用。
        /// </summary>
        /// <param name="e"></param>
        public KybernetesApplicationException(Exception e)
        {
            this.e = e;

            saveLog(e.Message);
            saveLog(e.StackTrace);
        }
        /// <summary>
        /// 業務エラー用。
        /// </summary>
        public KybernetesApplicationException()
        {
            saveLog("予期せぬエラーが発生しました。");
        }

        /// <summary>
        /// 業務エラー用
        /// </summary>
        /// <param name="errorMessage"></param>
        public KybernetesApplicationException(string errorMessage)
        {
            saveLog(errorMessage);
        }

        private void saveLog(string logContents)
        {
            KybernetesLogger.Log.error(logContents);
        }
    }

}
