﻿using com.andoutomo.kybernetes.view;
using com.andoutomo.kybernetes.control;

namespace com.andoutomo.kybernetes.command
{
    public abstract class AbCommand
    {
        protected abstract bool execute();


        protected abstract string turnMessage();
        protected abstract string turnErrorMessage();
        protected abstract string turnSplitErrorMessage();

        protected BaseForm form;
        protected CommandArg argument;


        /// <summary>
        /// 処理を実行する<br />
        /// 各継承先クラスで指定された、splitArguments及び
        /// executeを呼び出す。
        /// </summary>
        /// <param name="_args">呼び出す前に指定された引数(コマンドラインからなので、それを受け取る)</param>
        /// <param name="_form">フォーム情報。ここからフォームを操作できるようにします。</param>
        /// <returns></returns>
        public bool run(CommandArg _args, BaseForm _form)
        {
            KybernetesLogger.Log.debug("run start on " + this.GetType().ToString());
            if (_args.getSplitResult() == false)
            {
                KybernetesLogger.Log.debug("split failed at " + _args.GetType().ToString());
                message = turnSplitErrorMessage();
                return false;
            }

            this.argument = _args;
            this.form = _form;

            if (execute())
            {
                message = turnMessage();
                KybernetesLogger.Log.debug("run success on " + this.GetType().ToString());
                KybernetesLogger.Log.debug("message:" + message);
                return true;
            }
            else
            {
                message = turnErrorMessage();
                KybernetesLogger.Log.debug("run failure on " + this.GetType().ToString());
                KybernetesLogger.Log.debug("message:" + message);

                return false;
            }
        }

        private string message;

        
        /// <summary>
        /// 処理完了後のメッセージを呼び出し元に返す。
        /// </summary>
        /// <returns>メッセージ</returns>
        public string getMessage()
        {
            return message;
        }

        protected ErrorType errorType
        {
            private get;
            set;
        }

        protected string DefaultErrorMessage
        {
            get
            {
                string errorMessage;
                switch(errorType){
                    case ErrorType.DataNotFound:
                        errorMessage = "対象データが見つかりません。";
                        break;
                    case ErrorType.Unexpected:
                    default:
                        errorMessage = "予期せぬエラーが発生いたしました。";
                        break;

                }
                return errorMessage;
            
            }
        }
        protected string DefaultSplitErrorMessage
        {
            get { return "無効なパラメータです。"; }
        }
        protected string DefaultNormalMessage
        {
            get { return "> ";}
        }

    }
    public enum ErrorType
    {
        Unexpected,
        DataNotFound,

    }
}
