﻿
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
namespace com.andoutomo.kybernetes.command.template
{
    public abstract class StandardCommandArg:CommandArg
    {
        protected string[] splitData
        {
            get;
            private set;
        }
        protected bool isValid
        {
            private get;
            set;
        }
        
        public int sortID
        {
            get;
            private set;
        }

        public void split(string arguments)
        {
            splitData = arguments.Split(' ');
            if (splitData.Length < 2)
            {
                isValid = false;
                return;
            }
            int idWork;
            if (int.TryParse(splitData[1], out idWork))
            {
                sortID = idWork;
                isValid = true;
            }
            else
            {
                isValid = false;
            }
            if (isValid)
            {
                split();
            }
        }
        abstract protected void split();
        
        

        public bool getSplitResult()
        {
            return isValid;
        }
        /// <summary>
        /// 対象データの存在を確認します。
        /// </summary>
        /// <returns></returns>
        public bool dataExists()
        {
            return (TaskDataAccessor.getObject.getTask(sortID) != null);
        }
    }
}
