﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;

namespace com.andoutomo.kybernetes.command
{
    class HelpCommand:AbCommand
    {

        protected override bool execute()
        {
            HelpCommandArg thisArg = (HelpCommandArg)base.argument;
            CommandDataAccessor accessor = CommandDataAccessor.getObject;
            switch (thisArg.SubCommandType)
            {
                case HelpCommandType.ALL:
                case HelpCommandType.None:
                    
                    List<HelpData> allList = accessor.getAllHelp();

                    List<string> resList = new List<string>();
                    resList.Add(string.Empty);
                    resList.Add(" HELP ");
                    resList.Add(string.Empty);
                    resList.Add(" コマンドの一覧及び処理概要を表示します。");
                    resList.Add(string.Empty);

                    foreach (HelpData help in allList)
                    {
                        resList.Add("  " + help.cmdStr + "    " + help.cmdSummary);
                    }

                    base.form.addMultiText(resList);

                    break;
                case HelpCommandType.One:
                    List<string> resList2 = new List<string>();

                    HelpData data = accessor.getHelpData(thisArg.HelpCommandStr);
                    if (data != null)
                    {
                        string aliases = accessor.getAlies(thisArg.HelpCommandStr);

                        resList2.Add(string.Empty);
                        resList2.Add(" HELP " + thisArg.HelpCommandStr);
                        resList2.Add(string.Empty);
                        resList2.Add(data.cmdSummary);
                        resList2.Add(string.Empty);
                        resList2.Add("alies:");
                        resList2.Add(aliases);
                        resList2.Add(string.Empty);
                        resList2.Add(data.cmdDetail);

                        base.form.addMultiText(resList2);
                    }
                    else
                    {
                        return false;
                    }
                    break;
            }
            return true;
        }

        protected override string turnMessage()
        {
           return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return "不明なコマンドです。";
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
