﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using System.IO;

namespace com.andoutomo.kybernetes.command.SYSTEM
{
    class ExpCommand:AbCommand
    {
        protected override bool execute()
        {
            List<TaskData> allList = TaskDataAccessor.getObject.getAllTaskList();
            string filename = form.invokeExpDialog();

            StreamWriter writer = new StreamWriter(filename, false, System.Text.Encoding.GetEncoding("shift_jis"));
            writer.WriteLine(TaskData.CSVHeader);
            foreach (TaskData data in allList)
            {
                writer.WriteLine(data.CSVData);
            }

            writer.Close();
            return true;
        }

        protected override string turnMessage()
        {
            return "出力しました。";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
