﻿using System;
using System.IO;
using com.andoutomo.kybernetes.control;
using com.andoutomo.kybernetes.data.connection;

namespace com.andoutomo.kybernetes.command.SYSTEM
{
    class DmpCommand:AbCommand
    {
        protected override bool execute()
        {
            string maindb = System.AppDomain.CurrentDomain.BaseDirectory + TaskDBConnection.Connection.targetDbFile();
            string filePath = form.invokeDmpDialog();
            try
            {
                File.Copy(maindb, filePath, true);
                return true;
            }
            catch (FileNotFoundException fnfe)
            {
                message = "対象ファイルがありません。";
                throw new KybernetesApplicationException(fnfe);
            }
            catch (DirectoryNotFoundException dnfe)
            {
                message = "保存対象ディレクトリがありません。ディレクトリ作成後に出力してください。";
            }
            catch (UnauthorizedAccessException uaae)
            {
                message = "書き込みに失敗しました。保存先の権限、現在使用中でないかどうか等を確認して下さい。";
            }
            return false;
        }
        string message;
        protected override string turnMessage()
        {
            return "DBのエクスポートに成功しました。";
        }

        protected override string turnErrorMessage()
        {
            return message;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
