﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command.reference
{
    class SumCommand:AbCommand
    {
        protected override bool execute()
        {
            SumCommandArg param = (SumCommandArg)argument;

            List<int> targetList = param.targetData;
            int wkForcast = 0;
            int wkReal = 0;

            foreach (int sortID in targetList)
            {
                TaskData data = TaskDataAccessor.getObject.getTask(sortID);
                if (data != null)
                {
                    wkForcast += data.ForecastMin;
                    wkReal += data.RealMin;
                }
            }
            TimeComponent forcast = new TimeComponent(wkForcast);
            TimeComponent realTime = new TimeComponent(wkReal);


            List<string> resultList = new List<string>();
            resultList.Add("合計：");
            resultList.Add("予想時間：" + forcast.ToString() + " ( " + forcast.TotalMinute  + " 分)");
            resultList.Add("実績時間：" + realTime.ToString() + " ( " + realTime.TotalMinute + " 分)");

            form.addMultiText(resultList);

            return true;
        }

        protected override string turnMessage()
        {
            return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
