﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    class StartCommand:AbCommand
    {
        StartCommandArg param;
        protected override bool execute()
        {
            TaskDataAccessor accessor = TaskDataAccessor.getObject;

            param = (StartCommandArg)argument;
            if (param.AutoMode)
            {
                TaskData target = accessor.getTask(param.sortID);
                if (target != null)
                {
                    TimeComponent lastEndtime = accessor.getNextStartTime(target.DoDate);
                    if (lastEndtime != null && lastEndtime.IsValid)
                    {
                        return accessor.startTask(target.SortID, lastEndtime);
                    }
                    else
                    {
                        message = "終了しているタスクが無いため、自動設定できません。最初は手動設定してください。";
                        return false;
                    }
                }
                else
                {
                    base.errorType = ErrorType.DataNotFound;
                    return false;
                }
            }
            else
            {
                return accessor.startTask(param.sortID, param.StartTime);
            }
        }
        string message;

        protected override string turnMessage()
        {
            return "タスク " + param.sortID + " をスタートします。";
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultErrorMessage;
            }
                return message;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
