﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class ClearCommand:AbCommand
    {
        private int sortId;
        protected override bool execute()
        {
            ClearCommandArg param = (ClearCommandArg)argument;
            sortId = param.sortID;

            if (!param.dataExists())
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }

            return TaskDataAccessor.getObject.clearStartEnd(sortId);
        }

        protected override string turnMessage()
        {
            return "タスク " + sortId +" の実績をクリアしました。";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
