﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.command.reference;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command.CRUD
{
    class LongListCommand : EstimateCommand
    {
        protected override bool execute()
        {
            EstimateCommandArg param = (EstimateCommandArg)argument;
            DateComponent today = SettingDataAccessor.getObject.getToday();

            //タスクリストを取得
            List<TaskData> taskList;
            if (param.targetDate == null)
            {
                taskList = TaskDataAccessor.getObject.getToDayTaskList();
            }
            else
            {
                taskList = TaskDataAccessor.getObject.getDailyTaskList(param.targetDate);
            }
            
            form.clearPanel();

            string wkAreaForIndex = "";
            foreach (TaskData data in taskList)
            {
                data.Today = today;
                if (!data.isComplete)
                {
                    if (wkAreaForIndex != data.TimeArea)
                    {
                        string wkIndex = "- " + data.TimeArea + " - on " + data.DoDate.getDateString("yyyy/MM/dd");
                        form.addIndexPanel(wkIndex);
                    }

                    wkAreaForIndex = data.TimeArea;
                }
                form.addPanel(data);
            }
            //ベースクラスを呼び出し見積もりを表示する
            return base.execute();

        }

        protected override string turnMessage()
        {
            return "";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
