﻿
namespace com.andoutomo.kybernetes.command.CRUD
{
    class DeleteCommandArg:CommandArg
    {
        public int targetIDFrom
        {
            get;
            private set;
        }
        public int targetIDTo
        {
            get;
            private set;
        }

        private bool isValid;
        public void split(string arguments)
        {
            string[] splitData = arguments.Split(' ');
            if (splitData.Length < 2)
            {
                isValid = false;
                return;
            }
            //個別指定の場合
            if (splitData.Length < 3)
            {
                int wkID;
                if (int.TryParse(splitData[1], out wkID))
                {
                    targetIDFrom = wkID;
                    targetIDTo = wkID;
                    isValid = true;
                }
                else
                {
                    isValid = false;
                }
            }
            //範囲指定の場合
            else
            {
                int wkIDFrom;
                int wkIDTo;

                for (int i = 1; i < splitData.Length; i++) 
                {
                    string[] splitParamData = splitData[i].Split(':');
                    if (string.Equals(splitParamData[0].ToLower(), "f"))
                    {
                        if (int.TryParse(splitParamData[1], out wkIDFrom))
                        {
                            targetIDFrom = wkIDFrom;
                            isValid = true;
                        }
                        else
                        {
                            isValid = false;
                            break;
                        }
                    }
                    else if (string.Equals(splitParamData[0].ToLower(), "t"))
                    {
                        if (int.TryParse(splitParamData[1], out wkIDTo))
                        {
                            targetIDTo = wkIDTo;
                            isValid = true;
                        }
                        else
                        {
                            isValid = false;
                            break;
                        }
                    }
                }
            }
        }

        public bool getSplitResult()
        {
            return isValid;
        }
    }
}
