﻿using System;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using System.Collections.Generic;
using System.Windows.Forms;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    class AddCommand:AbCommand
    {

        private string message;
        protected override bool execute()
        {
            AddCommandArgs addArgs = (AddCommandArgs)base.argument;
            TaskData data = addArgs.PreparedTaskData;

            if (data.Contents == null)
            {
                data.Contents = form.showInputBox("実施事項を入力してください。",ImeMode.Hiragana);
                if (data.Contents == null || data.Contents == string.Empty)
                {
                    message = "処理を中断しました。";
                    return false;
                }
            }
            if (data.DoDate == null)
            {
                string dateStr =
                    form.showInputBox("日付をyyyyMMddかMMddで入力してください。空の場合は今日とします。");
                if (dateStr == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }

                if (dateStr == string.Empty)
                {
                    dateStr = SettingDataAccessor.getObject.getToday().getDateString("yyyyMMdd");
                }
                try
                {
                    data.DoDate = new data.DateComponent(dateStr);
                }
                catch (Exception e)
                {
                    message = "日付に不備がありました。お手数ですが最初からやり直してください。";
                    return false;
                }
                
            }
            if (data.TimeArea == null)
            {
                TimeComponent now = TimeComponent.justNow();
                string defaultTimeArea = TimeAreaDataAccessor.getObject.getDefaultTimeArea(now);

                string wkTimeArea = form.showInputBox("タイムエリアを選択してください(A-Z)",defaultTimeArea);
                
                if (string.IsNullOrEmpty(wkTimeArea))
                {
                    message = "処理を中断しました。";
                    return false;
                }
                data.TimeArea = wkTimeArea.ToUpper();
            }
            if (data.Category == null)
            {
                CategoryDataAccessor dataAccessor = CategoryDataAccessor.getObject;
                //string wkStr = form.showInputBox("カテゴリを記入してください。");
                List<CategoryData> allList = dataAccessor.getAllCategory();
                List<SimpleDataBean> dropdownList = new List<SimpleDataBean>();
                
                foreach (CategoryData categList in allList)
                {
                    dropdownList.Add(categList.dataForDropDown);
                }
                string wkStr = form.showDropBoxInputBox(dropdownList,"カテゴリを入力してください。");

                if (wkStr == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }

                CategoryData categData = dataAccessor.getCategoryFromName(wkStr);
                if (categData != null)
                {
                    data.CategID = categData.CategId;
                }
                else
                {
                    data.CategID = 0;
                }
            }
            else
            {
                data.CategID = addArgs.CategoryID;
            }
            if (data.ForecastMin == 0)
            {
                string wkFrcstMin = form.showInputBox("見積時間を分単位で入力してください。","0");
                if (wkFrcstMin == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }
                if (wkFrcstMin == string.Empty)
                {
                    wkFrcstMin = "0";
                    
                }
                if (wkFrcstMin.ToLower().EndsWith("h"))
                {
                    decimal forcastTime;
                    string timestr = wkFrcstMin.Substring(0, wkFrcstMin.Length - 1);
                    if (decimal.TryParse(timestr, out forcastTime))
                    {
                        data.ForecastMin = decimal.ToInt32(forcastTime * 60);
                    }
                }
                else
                {
                    data.ForecastMin = Convert.ToInt32(wkFrcstMin);                    
                }


            }

            //DBへの追加
            TaskDataAccessor taskAccessor = TaskDataAccessor.getObject;
            data.TaskID = taskAccessor.getMaxTaskID();
            if (data.SortID == 0)
            {
                data.SortID = taskAccessor.getMaxSortID();
            }
            if (taskAccessor.insertTask(data))
            {
                message = "タスクNo." + data.SortID + "「" + data.Contents + "」を追加しました。";
                return true;
            }
            else
            {
                message = "処理途中でエラーが発生しました。";
                return false;
            }
        }
        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultErrorMessage;
            }
            else
            {
                return message;
            }
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
