/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_tab.h"

#include <string.h>
#include "kazehakase.h"
#include "utils/intl.h"
#include "utils/gtk-utils.h"


#define DATA_KEY "KzPrefsTab::info"


static GtkWidget     *prefs_tab_create          (void);
static void           prefs_tab_response        (GtkWidget *widget,
						 gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/Tab"),
	priority_hint:   0,
	ui_level:        ~KZ_UI_LEVEL_BEGINNER,
	create:          prefs_tab_create,
	response:        prefs_tab_response,
};


typedef struct _KzPrefsTab
{
	GtkWidget     *main_vbox;
	GtkWidget     *fix_width_check;
	GtkWidget     *width_spin;
	GtkWidget     *show_favicon;
	GtkWidget     *show_close_button;
	GtkWidget     *show_progressbar;
	GtkOptionMenu *close_menu;
   	GtkWidget     *focus_new_tab;
   	GtkWidget     *focus_loc_ent;
	gboolean       changed;
} KzPrefsTab;


typedef struct
{
	gchar *title;
	gchar* code;
} PageToReturn;
static const PageToReturn page_to_return[] =
{
	{ N_("Next tab"),		"next_tab" },
	{ N_("Previous tab"),		"prev_tab" },
	{ N_("Last shown tab"),		"last_shown" },
	{ N_("Last created tab"),	"last_created" },
};
static const guint n_page_to_return = G_N_ELEMENTS (page_to_return);


static void
cb_fix_width_toggled(GtkToggleButton *button, KzPrefsTab *prefsui)
{
	gtk_widget_set_sensitive(prefsui->width_spin,
				 gtk_toggle_button_get_active(button));
	prefsui->changed = TRUE;
}

#if 0
static void
cb_focus_new_tab_toggled (GtkToggleButton *button, KzPrefsTab *prefsui)
{
   	gtk_widget_set_sensitive(prefsui->focus_loc_ent,
				 gtk_toggle_button_get_active(button));
	prefsui->changed = TRUE;
}
#endif

static void
cb_changed (GtkWidget *widget, KzPrefsTab *prefsui)
{
	prefsui->changed = TRUE;
}


static void
prefs_tab_destroy (gpointer data)
{
	KzPrefsTab *prefsui = data;

	g_free(prefsui);
}


static GtkWidget *
prefs_tab_create (void)
{
	KzPrefsTab *prefsui = g_new0(KzPrefsTab, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label, *check, *spin, *option_menu, *menu;
	GtkAdjustment *adj;
	gboolean fix, show, focus, key_focus;
	gint width;
	gchar *str;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_tab_destroy);

	label = kz_prefs_ui_utils_create_title(_("Tab"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);


	/*
	 *  tab width
	 */
	frame = gtk_frame_new(_("Width"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	fix = TRUE;
	KZ_CONF_GET("Tab", "fix_width", fix, BOOL);
	width = 80;
	KZ_CONF_GET("Tab", "fixed_width", width, INT);

	check = gtk_check_button_new_with_mnemonic(_("_Fix tab width"));
	prefsui->fix_width_check = check;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), fix);
	gtk_box_pack_start(GTK_BOX(hbox), check, FALSE, FALSE, 2);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_fix_width_toggled), prefsui);
	gtk_widget_show(check);

	prefsui->width_spin = spin
		= gtk_spin_button_new_with_range(-1, 1000, 1);
	adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin));
	gtk_adjustment_set_value(adj, width);
	gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 2);
	gtk_widget_set_sensitive(spin, fix);
	g_signal_connect(G_OBJECT(spin), "value-changed",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(spin);


	/*
	 *  Shiw/Hide
	 */
	frame = gtk_frame_new(_("Show/Hide"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Fav_icon"));
	prefsui->show_favicon = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	show = TRUE;
	KZ_CONF_GET("Tab", "show_favicon", show, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), show);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("C_lose button"));
	prefsui->show_close_button = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	show = TRUE;
	KZ_CONF_GET("Tab", "show_close_button", show, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), show);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("_Progress bar"));
	prefsui->show_progressbar = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	show = FALSE;
	KZ_CONF_GET("Tab", "show_progress", show, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), show);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);


	/*
	 *  Page to return when close the current tab
	 */
	frame = gtk_frame_new(NULL);
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	label = gtk_label_new_with_mnemonic(_("_Page to return when close the current tab"));
	gtk_frame_set_label_widget(GTK_FRAME(frame), label);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 4);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
	gtk_widget_show(hbox);

	option_menu = gtk_option_menu_new();
	prefsui->close_menu = GTK_OPTION_MENU(option_menu);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), option_menu);
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);

	GTKUTIL_CREATE_MENU(menu, page_to_return, n_page_to_return, title);
	gtk_option_menu_set_menu (GTK_OPTION_MENU(option_menu), menu);
	str = KZ_CONF_GET_STR("Tab", "page_to_return_when_close");
	GTKUTIL_SET_DEFAULT_HISTORY(option_menu, str,
				    page_to_return, n_page_to_return, code);
	g_free(str);
	g_signal_connect (G_OBJECT(option_menu), "changed",
			  G_CALLBACK (cb_changed), prefsui);
	gtk_widget_show(menu);

	/*
	 *  New Tab
	 */
	frame = gtk_frame_new(_("New Tab"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("_Move focus to new tab on NewTab Action"));
	prefsui->focus_new_tab = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	focus = FALSE;
	KZ_CONF_GET("Tab", "focus_open_new", focus, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), focus);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("Move _Keyboad focus to location entry when swich to new empty tab"));
	prefsui->focus_loc_ent = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	key_focus = FALSE;
	KZ_CONF_GET("Tab", "focus_loc_ent_new", key_focus, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), key_focus);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	prefsui->changed = FALSE;

	return main_vbox;
}


static void
prefs_tab_response (GtkWidget *widget, gint response)
{
	KzPrefsTab *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		GtkAdjustment *adj;
		gint width, i;
		gboolean fix_width;
		gboolean show_button, show_progress, show_favicon;
		gboolean focus_new_tab, focus_loc_ent;

		if (!prefsui->changed)
			break;

		fix_width = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->fix_width_check));
		KZ_CONF_SET("Tab", "fix_width", fix_width, BOOL);

		adj = gtk_spin_button_get_adjustment
			(GTK_SPIN_BUTTON(prefsui->width_spin));
		width = gtk_adjustment_get_value(adj);
		KZ_CONF_SET("Tab", "fixed_width", width, INT);

		show_favicon = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->show_favicon));
		KZ_CONF_SET("Tab", "show_favicon", show_favicon, BOOL);

		show_button = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->show_close_button));
		KZ_CONF_SET("Tab", "show_close_button", show_button, BOOL);

		show_progress = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->show_progressbar));
		KZ_CONF_SET("Tab", "show_progress", show_progress, BOOL);

		i = gtk_option_menu_get_history(prefsui->close_menu);
		if (i >= 0 && i < n_page_to_return)
			KZ_CONF_SET("Tab", "page_to_return_when_close",
				    page_to_return[i].code, STRING);

		focus_new_tab = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->focus_new_tab));
		KZ_CONF_SET("Tab", "focus_open_new", focus_new_tab, BOOL);

		focus_loc_ent = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->focus_loc_ent));
		KZ_CONF_SET("Tab", "focus_loc_ent_new", focus_loc_ent, BOOL);

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_tab_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
