/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_LINK_H__
#define __KZ_LINK_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include "glib.h"

G_BEGIN_DECLS

typedef struct _KzLink
{
	gchar *title;
	gchar *url;
	gint   ref_count;
} KzLink;

KzLink   *kz_link_new    (void);
KzLink   *kz_link_ref    (KzLink *kzlink);
void      kz_link_unref  (KzLink *kzlink);

/*
 *  Retun TRUE if filtered out by user-provided filter.
 */
gboolean  kz_link_filter (const KzLink *kzlink);

G_END_DECLS

#endif /* __KZ_LINK_H__ */
