#!/bin/sh
# $1 is TestLink install directory ex. /tmp/projects
if [ "$1" == "" ]; then
echo "undefined install directory"
exit
fi

TESTLINK_HOME="$1/testlink"

apt-get update
apt-get -y install apache2 apache2-devel
apt-get -y install php5 php5-apache2 php5-devel php5-pear php5-mysql
apt-get -y install mysql-server mysql-client

TESLINK_CONF="/etc/apache2/conf.d/testlink.conf"
echo "# TestLink configuration" > $TESLINK_CONF
echo "LoadModule php5_module modules/libphp5.so" >> $TESLINK_CONF
echo "AddType application/x-httpd-php .php" >> $TESLINK_CONF
echo "DirectoryIndex index.html index.htm index.html.var index.php " >> $TESLINK_CONF

wget http://downloads.sourceforge.net/testlink/testlink_1.8.1.tgz
tar xf testlink_1.8.1.tgz

mkdir -p $1
mv ./testlink $1

ln -s $TESTLINK_HOME /var/www/html/testlink
chmod a+w $TESTLINK_HOME/gui/templates_c/
chmod a+w $TESTLINK_HOME/upload_area/
chmod a+w $TESTLINK_HOME

/etc/init.d/apache2 restart
