/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* dfa_lookup.c --- lookup DFA terminal symbol from word info */

/* $Id: dfa_lookup.c,v 1.6 2004/03/22 04:14:31 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/dfa.h>

#include <ctype.h>

WORD_ID
dfa_symbol_lookup(DFA_INFO *dinfo, char *terminalname)
{
  WORD_ID id;
  int c;
  char *p;

  /* check if terminal name is digit */
  for(p=terminalname;*p!='\0';p++) {
    c = *p;
    if (! isdigit(c)) {
      j_printerr("Error: wrong format: terminal number is not digit in dict! [%s]\n", terminalname);
      return(WORD_INVALID);
    }
  }

  /* Currently, terminal ID is already assigned by mkdfa in wname,
     so this function only returns the ID */
  id = atoi(terminalname);
  if (id >= dinfo->term_num) return(WORD_INVALID); /* error */
  else return(id);
}
