/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* util.h --- misc. utility functions in util/ */

/* $Id: util.h,v 1.7 2004/03/23 03:00:16 ri Exp $ */

#ifndef __SENT_UTIL_H__
#define __SENT_UTIL_H__

/*
 *  Memory block size for mybmalloc() in bytes.
 *  mybmalloc does allocate memory per big block, though cannot free.
 *  It's for reading in large data (i.e. models).
 */
#define MYBMALLOC_BLOCK_SIZE 10000

typedef struct __bmalloc_base__ {
  void *base;			/* pointer to the malloced block */
  char *now, *end;		/* current point */
  struct __bmalloc_base__ *next;
} BMALLOC_BASE;

/* readfile.c */
char *getl(char *, int, FILE *);
char *getl_fp(char *, int, FILE *);
char *getl_fd(char *, int, int);
char *getl_sd(char *, int, int);
char *first_token(char *);
char *next_token(void);
char *next_token_if_any(void);
char *rest_token(void);

/* gzfile.c */
FILE *fopen_readfile(char *);
int fclose_readfile(FILE *);
FILE *fopen_writefile(char *);
int fclose_writefile(FILE *);
size_t myfread(void *ptr, size_t size, size_t n, FILE *fp);
size_t myfwrite(void *ptr, size_t size, size_t n, FILE *fp);
int myfeof(FILE *fp);

/* mybmalloc.c */
void mybmalloc_set_param();
void *mybmalloc(int);
void mybmalloc_free(void);
char *mybstrdup(char *);
void *mybmalloc2(int size, BMALLOC_BASE **list);
void mybfree2(BMALLOC_BASE **list);

/* mymalloc.c */
void *mymalloc(int);
void *myrealloc(void *, int);
void *mycalloc(int, int);

/* endian.c */
void swap_sample_bytes(short *buf, int len);
void swap_bytes(char *buf, size_t unitbyte, int unitnum);

/* j_printf.c */
#include <stdarg.h>
boolean j_printf_set_jconv(char *codestr);
void set_print_func(void (*print)(char *), void (*printerr)(char *), void (*flush)(void));
int j_printf(char *format, ...);
int j_printerr(char *format, ...);
int j_flushprint();
void j_error(char *format, ...);
void j_error_register_exitfunc(void (*error_func)());
void j_exit();
void j_exit_register_exitfunc(void (*exit_func)());

/* mystrtok.c */
char  *mystrtok_quotation(char *str, char *delim, int left_paren, int right_paren, int mode); /* mode:0=normal, 1=just move to next token */
char *mystrtok_quote(char *str, char *delim);
char *mystrtok(char *str, char *delim);
char *mystrtok_movetonext(char *str, char *delim);

#endif /* __SENT_UTIL_H__ */
