# Copyright 2014 Hiroyuki Tominaga
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#   REVISION LOG ENTRY
#
#	File name    : launch_propedit.sh
# 	Revision By  : (C) Copyright 2014 Hiroyuki Tominaga, All Rights Reserved.
#
#		Revised on: 2014-03-12 15:12:09
#		Summary   :
parent_directory() {
	pushd .>/dev/null;
	echo $(cd $(dirname $1);pwd)
	popd>/dev/null;
}


#
#SCRIPT_DIR=$(readlink -f $0)
SCRIPT_DIR=$(parent_directory $0)
CLASS_ROOT="$SCRIPT_DIR/propedit-1.15.2904.jar"; # classes

# awt.useSystemAAFontSettings: off on lcd lcd_hrgb
JAVA_AWT_OTPION="-Dswing.boldMetal=false -Dawt.useSystemAAFontSettings=on"
JAVA_OPTIONs=
APP_OPTIONs=

# jmx 接続を無効にするには以下を使用.
# XX_OPTIONs=-XX:+DisableAttachMechanism
XX_OPTIONs=
# for application debug flag.
DEBUG=

if [ -n "$DEBUG" ]; then
	#
	# [debug trace order tokens]
	# afx.debug      =afx.swing afx.plugin dnd util util.base64
	# propedit.debug =afx.plugin
	#
	JAVA_OPTIONs="-DISO8859_1Reader_base=$SCRIPT_DIR -DLog4jLogEventFactory=com.mylyane.afx.logging.log4j2.CustomLogEventFactory"
	APP_OPTIONs="-Dafx.debug=\"afx.swing afx.plugin dnd\" -Dpropedit.debug=afx.plugin"
fi

if [ "${1##*/*.}" = "jar" ]; then
	CLASS_ROOT="$(parent_directory ${1})/$(basename ${1})"
	shift
fi

CLASSPATH="${CLASS_ROOT}:$SCRIPT_DIR/log4j2.jar"

# config log4j2 if need.
if [ -n "$DEBUG" ]; then
	# if test "$PROM"=""; then echo "OK"; fi
	if [ "${PROMPT}" = "" ]; then
		LOG4J2_HOME=/usr/local/apache-log4j-2.0
	else
		LOG4J2_HOME=/f/ext_prg/develp/apache-log4j-2.0
	fi
	CLASSPATH="$CLASSPATH:$LOG4J2_HOME/log4j-api-2.0-rc1.jar:$LOG4J2_HOME/log4j-core-2.0-rc1.jar"

	echo "CLASSPATH=$CLASSPATH"
	echo "JAVA_OPTIONs=$JAVA_OPTIONs"

fi


echo "*******************************************************************************************"
echo
echo   Launch directory: $SCRIPT_DIR
echo   app classes root: $CLASS_ROOT
echo
echo   start properties editor application!
echo
echo "*******************************************************************************************"

CMD_LINE="java -cp $CLASSPATH $JAVA_AWT_OTPION $JAVA_OPTIONs $APP_OPTIONs $XX_OPTIONs ActivatorHook \"$@\""
eval $CMD_LINE
#java -cp "$CLASSPATH" $JAVA_AWT_OTPION $JAVA_OPTIONs "$APP_OPTIONs" $XX_OPTIONs ActivatorHook "$@"

