/* Copyright 2007 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.sample.minesweeper;

import jp.sourceforge.jlogtest.sample.minesweeper.Point;
import jp.sourceforge.jlogtest.sample.minesweeper.Size;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

public class SizeTest {
	
	private final Size size = new Size(3, 4); 

	@Test
	public void 直列化時の値を正しく返せる1() throws Exception {
		assertEquals(0, size.getSerializedPos(new Point(0, 0)));
	}

	@Test
	public void 直列化時の値を正しく返せる2() throws Exception {
		assertEquals(1, size.getSerializedPos(new Point(1, 0)));
	}

	@Test
	public void 直列化時の値を正しく返せる3() throws Exception {
		assertEquals(3, size.getSerializedPos(new Point(0, 1)));
	}

	@Test
	public void 直列化時の値を正しく返せる4() throws Exception {
		assertEquals(3 * 4 - 1, size.getSerializedPos(new Point(2, 3)));
	}
}
