/* Copyright 2007 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.sample.minesweeper;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


public class Utils {
	
	public static boolean[] toPrim(final Boolean[] array) {
		final boolean[] converted = new boolean[array.length];
		for (int i = 0; i < converted.length; i++)
			converted[i] = array[i];
		return converted;
	}
	
	public static Boolean[] toWrapper(final boolean[] array) {
		final Boolean[] converted = new Boolean[array.length];
		for (int i = 0; i < converted.length; i++)
			converted[i] = array[i];
		return converted;
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T[] rotate(final T[] board, final int num) {
		final T[] rotated = (T[])Array.newInstance(
				board.getClass().getComponentType(), board.length);
		
		for (int i = 0; i < board.length; i++)
			rotated[(i + num) % board.length]= board[i];
		
		return rotated;
	}

	public static <T> int findFirstIndex(final T[] array, final Pred<T> p) {
		for (int i = 0; i < array.length; i++) {
			if (p.eval(array[i]))
				return i;
		}
		return -1;
	}
	
	public static <T> boolean exists(final T[] array, final Pred<T> p) {
		for (final T item : array) {
			if (p.eval(item))
				return true;
		}
		return false;
	}
	
	public static <T> int count(final T[] array, final Pred<T> p) {
		int num = 0;
		for (final T item : array) {
			if (p.eval(item))
				num++;
		}
		return num;
	}
	
	public static <T> int count(final Collection<T> c, final Pred<T> p) {
		int num = 0;
		for (final T item : c) {
			if (p.eval(item))
				num++;
		}
		return num;
	}
	
	public static int count(final boolean[] array, final Pred<Boolean> p) {
		int num = 0;
		for (final boolean item : array) {
			if (p.eval(item))
				num++;
		}
		return num;
	}
	
	@SuppressWarnings("unchecked")
	public static <From, To> To[] map(
			Class<To> toClazz, final From[] array, final Callable<From, To> map) {

		final List<To> res = new ArrayList<To>(100);		
		for (final From item : array) {
			res.add(map.call(item));
		}
		return (To[])res.toArray((To[])Array.newInstance(toClazz, 0));
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T[] filter(final T[] array, final Pred<T> p) {
		final List<T> filtrated = new ArrayList<T>(100);
		for (final T item : array) {
			if (p.eval(item))
				filtrated.add(item);
		}
		return filtrated.toArray(
				(T[])Array.newInstance(array.getClass().getComponentType(), 0));
	}
	
	@SuppressWarnings("unchecked")
	public static <T> Set<T> filterAsSet(final Collection<T> array, final Pred<T> p) {
		final Set<T> filtrated = new HashSet<T>(100);
		for (final T item : array) {
			if (p.eval(item))
				filtrated.add(item);
		}
		return filtrated;
	}
	
	public static interface Pred<T> {
		boolean eval(T obj);
	}
	
	public static interface Callable<From, To> {
		To call(From obj);
	}
}
