/* Copyright 2007 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.sample.minesweeper;

import java.util.Arrays;

import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;

public class RandomPermutator implements IRandomPermutator {
	
	private final RandomData rData;

	public RandomPermutator() {
		rData = new RandomDataImpl(new JDKRandomGenerator());
	}

	public boolean[] getRandomizedMineMap(final int numOfCells, final int numOfMines) {
		final boolean[] toRandomize = new boolean[numOfCells];
		Arrays.fill(toRandomize, false);
		for (int i = 0; i < numOfMines; i++)
			toRandomize[i] = true;
		
		final Object[] randomized = rData.nextSample(
				Arrays.asList(Utils.toWrapper(toRandomize)), toRandomize.length);
		return Utils.toPrim(Utils.map(Boolean.class, randomized, new Utils.Callable<Object, Boolean>() {
			public Boolean call(final Object obj) {
				return (Boolean)obj;
			}
		}));
	}
}
