/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.jlogtest.DIContainer;
import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.JclLogType;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.annotations.JclLog;
import jp.sourceforge.jlogtest.annotations.Log;
import jp.sourceforge.jlogtest.annotations.Record;
import jp.sourceforge.jlogtest.annotations.Sequence;
import jp.sourceforge.jlogtest.annotations.TargetLogs;
import jp.sourceforge.jlogtest.junit.ILogDirectoryPath;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLogTestMethodRunner
extends TestMethodRunner {
    private final ILogDirectoryPath logDirectoryPath;
    private final Method method;
    private final Class<?> clazz;

    public JLogTestMethodRunner(Object test, Class<?> clazz, Method method, RunNotifier notifier, Description description, ILogDirectoryPath logDirectoryPath) {
        super(test, method, notifier, description);
        this.clazz = clazz;
        this.method = method;
        this.logDirectoryPath = logDirectoryPath;
    }

    protected void executeMethodBody() throws IllegalAccessException, InvocationTargetException {
        if (JLogTestMethodRunner.isForJLogTest(this.clazz, this.method)) {
            this.executeJLogTest();
        } else {
            super.executeMethodBody();
        }
    }

    private static boolean isForJLogTest(Class<?> clazz, Method method) {
        return clazz.isAnnotationPresent(TargetLogs.class) || method.isAnnotationPresent(TargetLogs.class);
    }

    private void executeJLogTest() throws IllegalAccessException, InvocationTargetException {
        IOperationMode operation;
        try {
            operation = JLogTestMethodRunner.isRecordMode(this.clazz, this.method) ? DIContainer.getOperationFactory().createRecordMode(this.logDirectoryPath.getPath(), this.clazz, this.method.getName()) : DIContainer.getOperationFactory().createPlayMode(this.logDirectoryPath.getPath(), this.clazz, this.method.getName());
            for (TargetSequence tSeq : JLogTestMethodRunner.getTargetSequences(this.clazz, this.method)) {
                operation.addTarget(tSeq);
            }
            operation.start();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        super.executeMethodBody();
        try {
            operation.stop();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private static TargetSequence[] getTargetSequences(Class<?> clazz, Method method) {
        CombinedTargetLogs logs = new CombinedTargetLogs(method.getAnnotation(TargetLogs.class), clazz.getAnnotation(TargetLogs.class));
        HashSet<TargetSequence> toReturn = new HashSet<TargetSequence>();
        for (String name : logs.sequences.keySet()) {
            toReturn.add(new TargetSequence(name, JLogTestMethodRunner.toJclLogType(logs.sequences.get((Object)name).jclLog), JLogTestMethodRunner.toJLogType(logs.sequences.get((Object)name).jlogType)));
        }
        return toReturn.toArray(new TargetSequence[0]);
    }

    private static Set<JclLogType> toJclLogType(Collection<JclLog> logs) {
        HashSet<JclLogType> logType = new HashSet<JclLogType>();
        for (JclLog log : logs) {
            logType.add(new JclLogType(log.clazz(), log.level()));
        }
        return logType;
    }

    private static Set<String> toJLogType(Collection<Log> logs) {
        HashSet<String> logType = new HashSet<String>();
        for (Log log : logs) {
            logType.add(log.value());
        }
        return logType;
    }

    private static boolean isRecordMode(Class<?> clazz, Method method) {
        return clazz.isAnnotationPresent(Record.class) || method.isAnnotationPresent(Record.class);
    }

    private static class CombinedTargetLogs {
        public final Map<String, CombinedTargetSequence> sequences = new HashMap<String, CombinedTargetSequence>();

        public CombinedTargetLogs(TargetLogs ... logs) {
            for (TargetLogs log : logs) {
                if (log == null) continue;
                for (Sequence seq : log.value()) {
                    if (!this.sequences.containsKey(seq.name())) {
                        this.sequences.put(seq.name(), new CombinedTargetSequence());
                    }
                    CombinedTargetSequence toAdd = this.sequences.get(seq.name());
                    toAdd.addJclLog(seq.jcl());
                    toAdd.addLog(seq.log());
                }
            }
        }
    }

    private static class CombinedTargetSequence {
        public final Set<JclLog> jclLog = new HashSet<JclLog>();
        public final Set<Log> jlogType = new HashSet<Log>();

        public void addJclLog(JclLog[] log) {
            Collections.addAll(this.jclLog, log);
        }

        public void addLog(Log[] log) {
            Collections.addAll(this.jlogType, log);
        }
    }
}

