/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public class XmlFileManipulator {
    private final String pathToBase;

    public XmlFileManipulator(String pathToBase) {
        this.pathToBase = pathToBase;
    }

    public void output(Element element, String clazz, String method) throws IOException {
        Document doc = new Document(element);
        FileOutputStream output = this.getOutputStream(clazz, method);
        try {
            Serializer serializer = new Serializer((OutputStream)output, "UTF-8");
            serializer.setIndent(4);
            serializer.setMaxLength(100);
            serializer.write(doc);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            throw new Error("System error!!", e);
        }
        finally {
            ((OutputStream)output).close();
        }
    }

    public Document input(String clazz, String method) throws ParsingException, IOException {
        return new Builder().build(XmlFileManipulator.getFile(this.pathToBase, clazz, method));
    }

    private FileOutputStream getOutputStream(String clazz, String method) throws FileNotFoundException {
        File fileToSaveXml = XmlFileManipulator.getFile(this.pathToBase, clazz, method);
        File dir = fileToSaveXml.getParentFile();
        dir.mkdirs();
        return new FileOutputStream(fileToSaveXml);
    }

    private static File getFile(String base, String clazz, String method) {
        return new File(String.format("%s/%s#%s.xml", base, XmlFileManipulator.qualifiedClassNameToPath(clazz), method));
    }

    private static String qualifiedClassNameToPath(String className) {
        return className.replace('.', '/');
    }
}

