/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.SequencesNotMatchException;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.Verifier;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierContainer
implements ILoggable {
    private final Map<String, Verifier> verifiers = new HashMap<String, Verifier>();
    private final Map<String, ILog[]> recordedLogs;

    public VerifierContainer(Map<String, ILog[]> recordedLogs) {
        this.recordedLogs = recordedLogs;
    }

    public void addSequence(TargetSequence sequence) {
        String name = sequence.getName();
        this.verifiers.put(name, new Verifier.FilterableVerifier(this.recordedLogs.get(name), sequence));
    }

    public void verifySequence() {
        Set<String> seqPlaying = this.verifiers.keySet();
        Set<String> seqRecorded = this.recordedLogs.keySet();
        Collection added = CollectionUtils.subtract(seqPlaying, seqRecorded);
        Collection removed = CollectionUtils.subtract(seqRecorded, seqPlaying);
        if (!added.isEmpty() || !removed.isEmpty()) {
            throw new SequencesNotMatchException(added, removed);
        }
    }

    @Override
    public void addLog(ILog log) {
        for (Verifier verifier : this.verifiers.values()) {
            verifier.addLog(log);
        }
    }

    public void finish() {
        for (Verifier verifier : this.verifiers.values()) {
            verifier.finish();
        }
    }
}

