/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.LogVerificationException;
import jp.sourceforge.jlogtest.TargetSequence;

public class Verifier
implements ILoggable {
    private final ILog[] expectedList;
    private int count;

    public Verifier(ILog[] expectedList) {
        this.expectedList = expectedList;
        this.count = 0;
    }

    public void addLog(ILog actual) {
        ILog expected;
        assert (this.invariant());
        if (this.expectedList.length == this.count) {
            Verifier.throwVerificationException(null, actual);
        }
        if (!(expected = this.expectedList[this.count++]).equals(actual)) {
            Verifier.throwVerificationException(expected, actual);
        }
    }

    public void finish() {
        assert (this.invariant());
        if (this.count != this.expectedList.length) {
            Verifier.throwVerificationException(this.expectedList[this.count], null);
        }
    }

    private boolean invariant() {
        return 0 <= this.count && this.count <= this.expectedList.length;
    }

    private static void throwVerificationException(ILog expected, ILog actual) {
        throw new LogVerificationException(expected, actual);
    }

    public static class FilterableVerifier
    extends Verifier {
        private final TargetSequence filter;

        public FilterableVerifier(ILog[] expectedList, TargetSequence filter) {
            super(expectedList);
            this.filter = filter;
        }

        public void addLog(ILog log) {
            if (this.filter.contains(log)) {
                super.addLog(log);
            }
        }
    }
}

