/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.JclLogLevel;
import jp.sourceforge.jlogtest.util.java.HashGen;
import jp.sourceforge.jlogtest.util.xom.ChildSelector;
import jp.sourceforge.jlogtest.util.xom.NodeCreator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;

public class JclLogInfo
implements ILog {
    public static final String JCLLOG = "jcllog";
    private static final String CLASS = "class";
    private static final String LEVEL = "level";
    private static final String TEXT = "text";
    private final String text;
    private final String className;
    private final JclLogLevel level;

    public JclLogInfo(String text, String className, JclLogLevel level) {
        this.text = text;
        this.className = className;
        this.level = level;
    }

    public JclLogInfo(Element jcllog) throws ParsingException {
        if (!JCLLOG.equals(jcllog.getLocalName())) {
            throw new ParsingException("no jcllog element");
        }
        try {
            this.text = JclLogInfo.getText(jcllog);
            this.className = jcllog.getAttributeValue(CLASS);
            this.level = JclLogLevel.valueOf(jcllog.getAttributeValue(LEVEL));
            if (this.text == null || this.className == null || this.level == null) {
                throw new ParsingException("parse failed");
            }
        }
        catch (Exception e) {
            throw new ParsingException("parse failed", (Throwable)e);
        }
    }

    private static String getText(Element jcllog) throws ParsingException {
        assert (JCLLOG.equals(jcllog.getLocalName()));
        ChildSelector selector = new ChildSelector((ParentNode)jcllog);
        if (!selector.isUnique(TEXT)) {
            throw new ParsingException("no jcllog element");
        }
        Element text = selector.getUniqueElement(TEXT);
        return text.getValue();
    }

    public String getText() {
        return this.text;
    }

    public String getClassName() {
        return this.className;
    }

    public JclLogLevel getJclLogLevel() {
        return this.level;
    }

    public Element asXml() {
        Element log = new Element(JCLLOG);
        log.addAttribute(new Attribute(CLASS, this.className));
        log.addAttribute(new Attribute(LEVEL, this.level.toString()));
        log.appendChild(this.getXmlTextPart());
        return log;
    }

    private Node getXmlTextPart() {
        Element text = new Element(TEXT);
        text.addAttribute(NodeCreator.getPreserveSpaceAttribute());
        text.appendChild(this.text);
        return text;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JclLogInfo)) {
            return false;
        }
        JclLogInfo info = (JclLogInfo)obj;
        return this.text.equals(info.text) && this.className.equals(info.className) && this.level.equals((Object)info.level);
    }

    public int hashCode() {
        return HashGen.gen(new Object[]{this.text, this.className, this.level});
    }

    public String asOutputString() {
        return String.format("class : %s\nlevel : %s\ntext : '%s'", new Object[]{this.className, this.level, this.text});
    }
}

