/*
 *	browser.js - SWFObject.js 簡易版スクリプト
 *
 *		著作者:
 *			HIROTAKA.YAMASHITA. 2008. - sousyu.yama@gmail.com 
 *
 *		ライセンス:
 *			the MIT License
 *			Copyright (c) 2008 HIROTAKA YAMASHITA. All Rights Reserved.
 *			http://www.opensource.org/licenses/mit-license.php
 *
 *		Flash バージョンは 9 以上が必要
 *
 *		以下のブラウザを推奨するスクリプト
 *			Windows:	Internet Explorer 7 以上
 *			Windows:	Firefox 2 以上
 *			Windows:	Safari 3 以上
 *			Windows:	Opera 9 以上
 *			Mac:		Firefox 2 以上
 *			Mac:		Safari 2 以上
 *			Mac:		Opera 9 以上
 *
 *  本スクリプトは、JW FLV MEDIA PLAYER 3.16 内の mediaplayer.swf の
 * 	使用を前提としたスクリプトです。
 *  JW FLV MEDIA PLAYER 3.16 内の swfobject.js の代わりとして使用します。
 *
 * 	原著作者:
 * 		JW FLV MEDIA PLAYER 3.16
 *		http://www.jeroenwijering.com/?item=JW_FLV_Media_Player
 *
 *		Commercial licenses
 *		The players are licensed under a Creative Commons License, allowing you to use,
 *		modify and redistribute them for noncommercial purposes. For commercial use,
 *		I distribute licenses of the script from 20 euros.
 *
 *		http://creativecommons.org/licenses/by-nc-sa/2.0/
 *
 * 		SWFObject v1.5: Flash Player detection and embed - http://blog.deconcept.com/swfobject/
 * 		SWFObject is (c) 2007 Geoff Stearns and is released under the MIT License:
 *
 * 		http://www.opensource.org/licenses/mit-license.php
 *
 */
if(typeof shade=="undefined"){
	var shade=new Object();
}
////////////////////////////////////////////////////////////////////////////////////////////
shade.Browser = function() {
	this.wwwFlag = false; 
	this.ieFlag = false;
	this.backcolor		= '0xcccccc';
	this.frontcolor		= '0x333333';
	this.lightcolor		= '0x0000ff';
	this.screencolor	= '0x000000';

	this.autostart 		= false;
	this.repeat 		= false;
	this.showeq 		= false;
	this.volume 		= 80;

	this.shownavigation = true;
	this.showstop 		= false;
	this.showdigits 	= true;
	this.usefullscreen 	= true;

	this.playList		= false;
	this.autoscroll		= true;
	this.displayheight	= 0;
	this.displaywidth 	= 0;
};
////////////////////////////////////////////////////////////////////////////////////////////
shade.Browser.prototype = {
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	プレイリストの設定
//
//		引数:	autoscroll		:自動スクロール
//				displayheight	:表示領域高さ
//				displaywidth:	:表示領域幅
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setPlayList: function (autoscroll, displayheight, displaywidth) {
		this.playList = true;
		if (typeof autoscroll != "undefined") {
			this.autoscroll = autoscroll;
		}
		if (typeof displayheight != "undefined") {
			this.displayheight = displayheight;
		}
		if (typeof displaywidth != "undefined") {
			this.displaywidth = displaywidth;
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	ナビゲーションの動作設定
//
//		引数:	shownavigation	:ナビゲーションバー表示
//				showstop		:STOP ボタン表示
//				showdigits		:タイマー表示
//				usefullscreen	:フルスクリーンボタン表示
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setNavigation: function (shownavigation, showstop, showdigits, usefullscreen) {
		if (typeof shownavigation != "undefined") {
			this.shownavigation = shownavigation;
		}
		if (typeof showstop != "undefined") {
			this.showstop = showstop;
		}
		if (typeof showdigits != "undefined") {
			this.showdigits = showdigits;
		}
		if (typeof usefullscreen != "undefined") {
			this.usefullscreen = usefullscreen;
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	プレイヤーの動作設定
//
//		引数:	autostart	:自動スタート
//				repeat		:繰返し
//				showeq		:EQ表示
//				volume		:音量
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setAction: function (autostart, repeat, showeq, volume) {
		if (typeof autostart != "undefined") {
			this.autostart = autostart;
		}
		if (typeof repeat != "undefined") {
			this.repeat = repeat;
		}
		if (typeof showeq != "undefined") {
			this.showeq = showeq;
		}
		if (typeof volume != "undefined") {
			this.volume = volume;
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	プレイヤーの色設定
//
//		引数:	bgcolor		:背景色
//				frcolor		:前景色
//				lgcolor		:ライト色
//				sccolor		:スクリーン色
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setColor: function (bgcolor, frcolor, lgcolor, sccolor) {
		if (typeof bgcolor != "undefined") {
			this.backcolor=bgcolor;
		}
		if (typeof frcolor != "undefined") {
			this.frontcolor=frcolor;
		}
		if (typeof lgcolor != "undefined") {
			this.lightcolor=lgcolor;
		}
		if (typeof sccolor != "undefined") {
			this.screencolor=sccolor;
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flash プラグインの確認 (バージョン9以上)
//
//		引数:	1		:p要素でメッセージ出力
//				2		:警告ダイアログでメッセージ出力
//				それ以外	:メッセージ非表示
//		戻り値:	true	:インストール済み
//				false	:未インストール
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	isFlashPlugin: function (flag) {
		var pluginFlag = false;

		if (this.isIE() || !navigator.plugins) {
			try {
				var flash = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");
				var verStr = flash.GetVariable("$version");
				var verAry = verStr.split(",", 1);
				var version = verAry[0].replace(/WIN /i,'');
				if (version >= 9){
					pluginFlag = true;
				}
			} catch (ex) {}
		} else {
			if (navigator.mimeTypes['application/x-shockwave-flash']) {
				var flash = navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin;
				if (flash && flash.description) {
					var verAry = flash.description.split(".", 1);
					var version = verAry[0].replace(/^[A-Za-z\s]+/, '');
					if (version >= 9){
						pluginFlag = true;
					}
				}
			}
		}

		if (!pluginFlag) {
															// Flash 未インストール時のメッセージ
			var msg = "Flash ver.9 or later プラグインがインストールされていません。";
			if (flag == 1) {
				document.write('<p id="checkFlashMessage">' + msg + '</p>');
			} else if (flag == 2) {
				alert(msg);
			}
		}
		return pluginFlag;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flashプレイヤー flashvarsパラメータ設定
//
//		引数:	file	:再生ファイルのURL
//				width	:プレイヤー横幅
//				height	:プレイヤー高さ
//				var		:その他の任意項目
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setFlashPlayer: function (file, width, height) {

		var str = 'width=' + width + '&height=' + height;
		str += '&file=' + file;

		str += '&backcolor=' + this.backcolor;
		str += '&frontcolor=' + this.frontcolor;
		str += '&lightcolor=' + this.lightcolor;
		str += '&screencolor=' + this.screencolor;

		str += '&autostart=' + this.autostart;
		str += '&repeat=' + this.repeat;
		str += '&showeq=' + this.showeq;
		str += '&volume=' + this.volume;

		str += '&shownavigation=' + this.shownavigation;
		str += '&showstop=' + this.showstop;
		str += '&showdigits=' + this.showdigits;
		str += '&usefullscreen=' + this.usefullscreen;

		if (this.playList) {
			str += '&autoscroll=' + this.autoscroll;
			if (this.displayheight != 0) {
				str += '&displayheight=' + this.displayheight;
			}
			if (this.displaywidth != 0) {
				str += '&displaywidth=' + this.displaywidth;
			}
		}

		return str;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flashプレイヤー (mediaplayer.swf用)
//
//		Flash プラグインが未インストールの場合は、何もしない
//
//		引数:	file	:再生ファイルのURL
//				width	:プレイヤー横幅
//				height	:プレイヤー高さ
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	flashPlayer: function (player, file, width, height) {
		if (!this.isFlashPlugin(0)) {
			return;
		}

		if (!this.wwwFlag) {
			document.write ('<embed src="' + player + '"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '"');
			document.write (' allowfullscreen="true"');
			str = this.setFlashPlayer(file, width, height);
			document.write (' flashvars="' + str + '" />');
		} else if (this.isIE()) {
			// IE用出力
			document.write ('<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="movie" value="' + player + '" />');
			document.write ('<param name="allowfullscreen" value="true" />');
			str = this.setFlashPlayer(file, width, height);
			document.write ('<param name="flashvars" value="' + str + '" />');
			document.write ('</object>');
		} else {
			// IE以外のブラウザ用出力
			document.write ('<object data="' + player + '"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="allowfullscreen" value="true" />');
			str = this.setFlashPlayer(file, width, height);
			document.write ('<param name="flashvars" value="' + str + '" />');
			document.write ('</object>');

		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	InternetExplorerの確認
//
//		引数:	なし
//		戻り値:	true	:使用ブラウザはIE
//				false	:使用ブラウザはIE以外
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	isIE: function () {
		return this.ieFlag;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	ブラウザチェック (推奨ブラウザかチェック)
//
//		引数:	1		:p要素でメッセージ出力
//				2		:警告ダイアログでメッセージ出力
//				それ以外	:メッセージ非表示
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	checkBrowser: function (disp) {
		var msg = "";
		var ua = navigator.userAgent.toUpperCase();
		var os = this.getOperatingSystem(ua);
		var valid = this.validBrowser(ua, os);
		if (!valid || !document.getElementById) {
																	//非推奨ブラウザ用メッセージ
			msg =  "お使いのブラウザ環境は検証されていません。";
			msg += "正常に表示できない可能性があります。";
		} else {
			valid = this.versionCheck(ua, os);
			if (!valid) {
														//推奨ブラウザのバージョン違い用メッセージ
				msg = "お使いのブラウザバージョンでは、正常に表示できない可能性があります。";
			} else {
				this.wwwFlag = true;
			}
		}
		if (msg) {
			if (disp == 1) {
				document.write('<p id="checkBrowserMessage">' + msg + '</p>');
			} else if (disp == 2) {
				alert(msg);
			}
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	ブラウザバージョンチェック
//
//		引数:	ua		:navigator.userAgent の値
//				os		:OS名 (WIN:Windows, MAC:Macintosh, OTHER:それ以外)
//		戻り値:	true	:対応済みバージョン
//				false	:未対応バージョン
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	versionCheck: function (ua, os) {
		for (var i = 0; i < this.validData.length; i++) {
			var bName = this.validData[i].name;
			var bOs   = this.validData[i].os;
			var idx = ua.indexOf(bName);
			if (idx != -1 && bOs == os)	{
				idx = ua.indexOf(this.validData[i].versionString);
				if (idx == -1) break;
				var bVersion = this.validData[i].version;
				var vStr = ua.substring(idx + this.validData[i].versionString.length);
				var version  = parseFloat(vStr);
				return (bVersion <= version) ? true : false;
			}
		}
		return false;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	検証対象ブラウザの確認
//
//		引数:	ua		:navigator.userAgent の値
//				os		:OS名 (WIN:Windows, MAC:Macintosh, OTHER:それ以外)
//		戻り値:	true	:検証対象ブラウザ
//				false	:未対象バージョン
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	validBrowser: function (ua, os) {
		for (var i = 0; i < this.validData.length; i++) {
			var bName = this.validData[i].name;
			var bOs   = this.validData[i].os;
			var idx = ua.indexOf(bName);
			if (idx != -1 && bOs == os)	{
				if (this.validData[i].name == "MSIE") {
					this.ieFlag = true;
				} else {
					this.ieFlag = false;
				}
				return true;
			}
		}
		return false;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	OSの判定
//
//		引数:	ua		:navigator.userAgent の値
//		戻り値:	WIN		:Windows
//				MAC		:Macintosh
//				OTHER	:上記以外
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	getOperatingSystem: function (ua) {
		var idx = ua.indexOf("WINDOWS");
		if (idx != -1) {
			return "WIN";
		}
		idx = ua.indexOf("MAC");
		if (idx != -1) {
			return "MAC";
		}
		return "OTHER";
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	対象ブラウザデータ
//
//		navigator.userAgent の値による判定に使用
//
//		name			:ブラウザ名
//		os				:OS名
//		versionString	:バージョン情報区切り文字列
//		version			:推奨バージョン番号
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	validData: [
		{
			name:			"MSIE",
			os:				"WIN",
			versionString:	"MSIE ",
			version:		7
		},
		{
			name:			"SAFARI",
			os:				"WIN",
			versionString:	"SAFARI/",
			version:		522
		},
		{
			name:			"SAFARI",
			os:				"MAC",
			versionString:	"SAFARI/",
			version:		412
		},
		{
			name:			"FIREFOX",
			os:				"WIN",
			versionString:	"FIREFOX/",
			version:		2
		},
		{
			name:			"FIREFOX",
			os:				"MAC",
			versionString:	"FIREFOX/",
			version:		2
		},
		{
			name:			"OPERA",
			os:				"WIN",
			versionString:	"OPERA/",
			version:		9
		},
		{
			name:			"OPERA",
			os:				"MAC",
			versionString:	"OPERA/",
			version:		9
		}
	]
};
////////////////////////////////////////////////////////////////////////////////////////////
if(typeof Browser=="undefined"){
	var Browser = new shade.Browser();
}
// で始まる行はコメントアウトされます。
//Browser.checkBrowser(0);	//メッセージ非表示
//Browser.checkBrowser(1);	//p要素でメッセージ表示
//Browser.checkBrowser(2);	//警告ダイアログでメッセージ表示
