﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using J_ColPicker;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void saveFileDialog1_FileOk(object sender, CancelEventArgs e)
        {
            textBox1.Text = saveFileDialog1.FileName;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            saveFileDialog1.ShowDialog();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            comboBox1.SelectedIndex = 0;
            comboBox2.SelectedIndex = 0;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Length == 0)
            {
                MessageBox.Show("保存先の指定がありません");
                return;
            }

            //画像を作成するメイン
            try
            {
                workLabel.Text = "作業中です...";
                workLabel.Visible = true;

                float[] pow = new float[2];
                pow[0] = float.Parse(comboBox1.Text);
                pow[1] = float.Parse(comboBox2.Text);

                Microsoft.Xna.Framework.Point pt = clsPickerData.GetMaxPoints(ref pow);
                
                //サイズを変更
                pictureBox1.Size = new Size(pt.X, pt.Y);

                //画像を作成していく
                pictureBox1.Image = new Bitmap(pictureBox1.Width, pictureBox1.Height);
                using (Graphics grfx = Graphics.FromImage(pictureBox1.Image))
                {

                    Pen pen;
                    Color frmCol;

                    //非常にややこしいが、XNA形式のColorとWinForm形式のColorが混在することになる
                    Microsoft.Xna.Framework.Color XnaCol;
                    Microsoft.Xna.Framework.Point nowP = new Microsoft.Xna.Framework.Point();

                    for (int x = 0; x < pictureBox1.Width; x++)
                    {
                        for (int y = 0; y < pictureBox1.Height; y++)
                        {
                            nowP.X = x; nowP.Y = y;

                            //XNA形式のColorで取得
                            XnaCol = clsPickerData.PickerXYtoRGB(ref nowP, ref pow);
                            //それを、WinForm形式のColorへ
                            frmCol = Color.FromArgb(XnaCol.R, XnaCol.G, XnaCol.B);
                            pen = new Pen(frmCol, 1);
                            //色を設置
                            grfx.DrawRectangle(pen, x, y, 1, 1);
                        }
                    }
                }
                pictureBox1.Invalidate();
            }
            catch
            {
                MessageBox.Show("何故だ･･･");
                workLabel.Text = "吊ってきます";
                return;
            }

            //画像の生成が出来たので、その画像を保存
            try
            {
                pictureBox1.Image.Save(textBox1.Text, System.Drawing.Imaging.ImageFormat.Png);
                workLabel.Text = "完了しました";
            }
            catch
            {
                MessageBox.Show("どうしてこうなった･･･");
                workLabel.Text = "すまぬ...";
            }
        }
    }
}
