/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/text/ExtMultiLineRule.java,v 1.5 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.5 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.text;


import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

/**
 * ExtMultiLineRule
 * <!-- #IntID:00009 // comment type support -->
 * @since 1.0.0
 */
public class ExtMultiLineRule extends MultiLineRule implements IExtRule {
    
    /**
     * Initiate ExtMultiLineRule.
     * @param start start string.
     * @param end   end string.
     * @param token color defined token.
     */
    public ExtMultiLineRule(String start, String end, IToken token) {
        super(start, end, token);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#activateColor(jp.sourceforge.jeextension.editor.editors.ColorManager)
     */
    public void activateColor(IColorManager cm) {
        Object obj = super.fToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator) obj).activateColor(cm);
        }
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#getWords()
     */
    public String[] getWords() {
        return new String[] {
            new String(super.fStartSequence),
            new String(super.fEndSequence),
        };
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.rule.IExtRule#setWords(java.lang.String[])
     */
    public void setWords(String[] words) {
        super.fStartSequence = words[0].toCharArray();
        super.fEndSequence   = words[1].toCharArray();
    }
    
    /**
     * {@inheritDoc}
     * Fixed, when fStartSequence matche it,
     * check the before char that is not escape char.
     * 
     * @see org.eclipse.jface.text.rules.PatternRule#doEvaluate(org.eclipse.jface.text.rules.ICharacterScanner, boolean)
     */
    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        
        super.fEscapeCharacter = '\\';
        if (resume) {
            
            if (endSequenceDetected(scanner)) {
                return fToken;
            }
            
        } else {
            
            int c = scanner.read();
            if (c == fStartSequence[0]) {
                if (((RuleBasedPartitionScanner) scanner).getTokenOffset()
                        != 0) {
                    scanner.unread();
                    scanner.unread();
                    int c1 = scanner.read();
                    scanner.read();
                    if (c1 == '\\') {
                        scanner.unread();
                        return Token.UNDEFINED;
                    }
                }
                
                // #IntID:00009 /**/ comment type support
                char c1 = (char) scanner.read();
                char c2 = (char) scanner.read();
                char c3 = (char) scanner.read();
                scanner.unread();
                scanner.unread();
                scanner.unread();
                if (c == '/' && c1 == '*' && c2 == '*' && c3 == '/'
                        && fStartSequence.length == 3) {
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                
                if (sequenceDetected(scanner, fStartSequence, false)) {
                    if (endSequenceDetected(scanner)) {
                        return fToken;
                    }
                }
            }
            
        }
        
        scanner.unread();
        return Token.UNDEFINED;
    }
}
