/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/StyleEditorCore.java,v 1.7 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.7 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;

/**
 * StyleEditor Core Class.
 * @since 2.0.0
 */
public class StyleEditorCore {
    
    /** Active Editors */
    private final Map fActiveEditorCache = new HashMap();
    
    /** Active SourceViewerConfiguration */
    private final Map fActiveConfigCache = new HashMap();
    
    /**
     * Jeex Style Editor's Tool.
     */
    private StyleEditorTools fEditorTools;
    
    /**
     * Jeex Style Editor's ColorManager.
     */
    private IColorManager fColorManager;
    
    /**
     * Default Constructor.
     */
    public StyleEditorCore() {
        super();
    }
    
    /**
     * Return Jeex Style Editor's Tool.
     * @return EditorTools
     */
    public synchronized StyleEditorTools getEditorTools() {
        if (fEditorTools == null) {
            fEditorTools = new StyleEditorTools();
        }
        return fEditorTools;
    }
    
    /**
     * Return Jeex Style Editor's ColorManager.
     * @return ColorManager
     */
    public synchronized IColorManager getColorManager() {
        if (fColorManager == null) {
            fColorManager = new StyleEditorColorManager();
        }
        return fColorManager;
    }
    
    /**
     * Return Active Editor for ActionContributorHelper
     * @param contrib   ActionContributorHelper
     * @return  Active Editor
     */
    public IEditorPart getActiveEditorPart(ActionContributorHelper contrib) {
        return (IEditorPart) fActiveEditorCache.get(contrib);
    }
    
    /**
     * Set Active Editor for ActionContributorHelper
     * @param contrib   ActionContributorHelper
     * @param editor    Active Editor
     */
    public void setActiveEditorPart(
            ActionContributorHelper contrib, IEditorPart editor) {
        fActiveEditorCache.put(contrib, editor);
    }
    
    /**
     * Remove Active Editor for ActionContributorHelper
     * @param contrib   ActionContributorHelper
     */
    public void removeActiveEditorPart(ActionContributorHelper contrib) {
        fActiveEditorCache.remove(contrib);
    }
    
    /**
     * Return SourceViewerConfiguration for ISourceViewer
     * @param viewer    ISourceViewer
     * @return  SourceViewerConfiguration
     */
    public SourceViewerConfiguration
                                getActiveViewerConfig(ISourceViewer viewer) {
        return (SourceViewerConfiguration) fActiveConfigCache.get(viewer);
    }
    
    /**
     * Set SourceViewerConfiguration for ISourceViewer
     * @param viewer    ISourceViewer
     * @param config    SourceViewerConfiguration
     */
    public void setActiveViewerConfig(
            ISourceViewer viewer, SourceViewerConfiguration config) {
        fActiveConfigCache.put(viewer, config);
    }
    
    /**
     * Remove SourceViewerConfiguration for ISourceViewer
     * @param viewer    ISourceViewer
     */
    public void removeActiveViewerConfig(ISourceViewer viewer) {
        fActiveConfigCache.remove(viewer);
    }
    
    /**
     * dispose objects.
     */
    public void dispose() {
        fActiveEditorCache.clear();
        fActiveConfigCache.clear();
        fColorManager.dispose();
    }
}
