/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/ISourceViewerActivator.java,v 1.4 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.4 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;

/**
 * ISourceViewerActivator
 * @since 2.0.0
 */
public interface ISourceViewerActivator {
    
    /**
     * Reactivate the ISourceViewer by each other SourceViewerConfiguration
     * implementation classes.<br>
     * <br>
     * SourceViewerConfiguration, JavaSourceViewerConfiguration, etc.
     * 
     * @param viewer            target ISourceViewer
     * @param document          target IDocument
     * @param sourceViewerClass SourceViewerConfiguration class
     * @param part              target IEditorPart
     */
    void activate(ISourceViewer viewer,
            IDocument document, Class sourceViewerClass, IEditorPart part);
}
